/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.url.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.osgi.framework.util.FilePath;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.storage.url.reference.ReferenceInputStream;

public class ReferenceURLConnection
extends URLConnection {
    private final String installPath;
    private URL reference;

    protected ReferenceURLConnection(URL url, String installPath) {
        super(url);
        this.installPath = installPath;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            String decodePath;
            File f;
            String path = this.url.getPath().substring(5);
            File file = new File(path);
            if (!file.isAbsolute() && this.installPath != null) {
                file = ReferenceURLConnection.makeAbsolute(this.installPath, file);
            }
            if (!file.exists() && path.indexOf(37) >= 0 && (f = new File(decodePath = EquinoxConfiguration.decode(file.getAbsolutePath()))).exists()) {
                file = f;
            }
            URL ref = file.toURL();
            this.checkRead(file);
            this.reference = ref;
        }
    }

    private void checkRead(File file) throws IOException {
        File[] files;
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (file.isFile()) {
            FileInputStream is = new FileInputStream(file);
            ((InputStream)is).close();
        } else if (file.isDirectory() && (files = file.listFiles()) == null) {
            throw new FileNotFoundException(file.toString() + " (probably access denied)");
        }
    }

    @Override
    public boolean getDoInput() {
        return true;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ReferenceInputStream(this.reference);
    }

    private static File makeAbsolute(String base, File relative) {
        if (relative.isAbsolute()) {
            return relative;
        }
        return new File(new FilePath(base + relative.getPath()).toString());
    }
}

