/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.AutoStartDirective;
import com.github.veithen.cosmos.osgi.runtime.BundleContextFactory;
import com.github.veithen.cosmos.osgi.runtime.BundleImpl;
import com.github.veithen.cosmos.osgi.runtime.BundleManager;
import com.github.veithen.cosmos.osgi.runtime.PackageAdminImpl;
import com.github.veithen.cosmos.osgi.runtime.ResourceProcessor;
import com.github.veithen.cosmos.osgi.runtime.ResourceUtil;
import com.github.veithen.cosmos.osgi.runtime.ServiceReferenceImpl;
import com.github.veithen.cosmos.osgi.runtime.ServiceRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.xml.XMLParserActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosRuntime {
    private static final Logger logger = LoggerFactory.getLogger(CosmosRuntime.class);
    private static CosmosRuntime instance;
    private final Properties properties = new Properties();
    private final BundleManager bundleManager = new BundleManager();
    private final ServiceRegistry serviceRegistry = new ServiceRegistry();

    private CosmosRuntime() throws BundleException {
        BundleContextFactory bundleContextFactory = new BundleContextFactory(this, this.bundleManager, this.serviceRegistry);
        this.bundleManager.initialize(bundleContextFactory);
        this.loadProperties("META-INF/cosmos/framework.properties");
        if (logger.isDebugEnabled()) {
            this.loadProperties("META-INF/cosmos/framework-debug.properties");
            logger.debug(String.format("Properties: %s", this.properties));
        }
        AbstractBundle systemBundle = this.bundleManager.getBundle(0L);
        this.registerSAXParserFactory(systemBundle);
        this.registerDocumentBuilderFactory(systemBundle);
        systemBundle.getBundleContext().registerService(PackageAdmin.class, (Object)new PackageAdminImpl(this.bundleManager), null);
        systemBundle.getBundleContext().registerService(Logger.class, (Object)logger, null);
        final ArrayList<AutoStartDirective> autoStartDirectives = new ArrayList<AutoStartDirective>();
        for (AbstractBundle bundle : this.bundleManager.getBundles()) {
            String value = bundle.getHeaderValue("Cosmos-AutoStart");
            if (value == null) continue;
            autoStartDirectives.add(new AutoStartDirective(bundle, value.equals("true") ? 0 : Integer.parseInt(value)));
        }
        ResourceUtil.processResources("META-INF/cosmos/autostart-bundles.list", new ResourceProcessor(){

            @Override
            public void process(URL url, InputStream in) throws IOException, BundleException {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    Bundle bundle;
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    int order = 0;
                    int idx = line.indexOf(61);
                    if (idx != -1) {
                        order = Integer.parseInt(line.substring(idx + 1));
                        line = line.substring(0, idx);
                    }
                    if ((bundle = CosmosRuntime.this.bundleManager.getBundle(line)) == null) {
                        throw new BundleException(String.format("Bundle %s listed in %s not found", line, url));
                    }
                    autoStartDirectives.add(new AutoStartDirective(bundle, order));
                }
            }
        });
        Collections.sort(autoStartDirectives, (d1, d2) -> Integer.compare(d1.getOrder(), d2.getOrder()));
        for (AutoStartDirective autoStartDirective : autoStartDirectives) {
            autoStartDirective.getBundle().start();
        }
    }

    private void registerSAXParserFactory(Bundle bundle) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Hashtable props = new Hashtable();
        new XMLParserActivator().setSAXProperties(factory, props);
        bundle.getBundleContext().registerService(SAXParserFactory.class, (Object)factory, props);
    }

    private void registerDocumentBuilderFactory(Bundle bundle) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Hashtable props = new Hashtable();
        new XMLParserActivator().setDOMProperties(factory, props);
        bundle.getBundleContext().registerService(DocumentBuilderFactory.class, (Object)factory, props);
    }

    private void loadProperties(String resourceName) throws BundleException {
        ResourceUtil.processResources(resourceName, new ResourceProcessor(){

            @Override
            public void process(URL url, InputStream in) throws IOException {
                CosmosRuntime.this.properties.load(in);
            }
        });
    }

    public static synchronized CosmosRuntime getInstance() throws BundleException {
        if (instance == null) {
            instance = new CosmosRuntime();
        }
        return instance;
    }

    String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            System.getProperty(key);
        }
        if (value == null && logger.isDebugEnabled()) {
            logger.debug("No value for property " + key);
        }
        return value;
    }

    public <T> T getService(Class<T> clazz) {
        ServiceReference<T> ref = this.serviceRegistry.getServiceReference(clazz.getName(), null, clazz);
        return ref == null ? null : (T)((ServiceReferenceImpl)ref).getService(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractBundle[] bundles = this.bundleManager.getBundles();
        ArrayList<BundleImpl> bundlesToStop = new ArrayList<BundleImpl>(bundles.length);
        for (AbstractBundle bundle : bundles) {
            if (!(bundle instanceof BundleImpl) || bundle.getState() != 32) continue;
            bundlesToStop.add((BundleImpl)bundle);
        }
        Collections.sort(bundlesToStop, new Comparator<BundleImpl>(){

            @Override
            public int compare(BundleImpl o1, BundleImpl o2) {
                return o2.getStartOrder() - o1.getStartOrder();
            }
        });
        for (BundleImpl bundle : bundlesToStop) {
            try {
                bundle.stop();
            }
            catch (BundleException ex) {
                logger.warn(String.format("Failed to stop bundle %s", bundle.getSymbolicName()), (Throwable)ex);
            }
        }
        Class<CosmosRuntime> clazz = CosmosRuntime.class;
        synchronized (CosmosRuntime.class) {
            instance = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

