/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.ServiceContext;
import com.github.veithen.cosmos.osgi.runtime.ServiceReferenceImpl;
import com.github.veithen.cosmos.osgi.runtime.ServiceRegistry;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Service<S>
implements ServiceRegistration<S> {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private static final Set<String> nonUpdateableProperties = new HashSet<String>(Arrays.asList("objectClass", "service.bundleid", "service.id", "service.scope"));
    private final ServiceRegistry serviceRegistry;
    private final AbstractBundle bundle;
    private final String[] classes;
    private final ServiceFactory<S> serviceFactory;
    private final Dictionary<String, Object> properties;
    private final Map<AbstractBundle, ServiceContext<S>> contexts = new HashMap<AbstractBundle, ServiceContext<S>>();
    private final ServiceReference<S> reference;

    Service(ServiceRegistry serviceRegistry, AbstractBundle bundle, String[] classes, ServiceFactory<S> serviceFactory, Dictionary<String, Object> properties) {
        this.serviceRegistry = serviceRegistry;
        this.bundle = bundle;
        this.classes = classes;
        this.serviceFactory = serviceFactory;
        this.properties = properties;
        this.reference = new ServiceReferenceImpl<S>(this){

            @Override
            S getService(AbstractBundle bundle) {
                return Service.this.getService(bundle);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matches(String clazz, Filter filter) {
        Dictionary<String, Object> dictionary = this.properties;
        synchronized (dictionary) {
            if (clazz != null) {
                boolean classMatches = false;
                for (String c : this.classes) {
                    if (!c.equals(clazz)) continue;
                    classMatches = true;
                    break;
                }
                if (!classMatches) {
                    return false;
                }
            }
            return filter == null || filter.matchCase(this.properties);
        }
    }

    ServiceFactory<S> getServiceFactory() {
        return this.serviceFactory;
    }

    S getService(AbstractBundle bundle) {
        ServiceContext<S> context = this.contexts.get(bundle);
        if (context == null) {
            context = new ServiceContext(this, bundle);
            this.contexts.put(bundle, context);
        }
        return context.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProperty(String key) {
        Dictionary<String, Object> dictionary = this.properties;
        synchronized (dictionary) {
            return this.properties == null ? null : this.properties.get(key);
        }
    }

    Bundle getBundle() {
        return this.bundle;
    }

    public ServiceReference<S> getReference() {
        return this.reference;
    }

    <T> ServiceReference<T> getReference(final Class<T> type) {
        return new ServiceReferenceImpl<T>(this){

            @Override
            T getService(AbstractBundle bundle) {
                return type.cast(Service.this.getService(bundle));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary<String, ?> newProperties) {
        Dictionary<String, Object> dictionary = this.properties;
        synchronized (dictionary) {
            Enumeration<String> keys = newProperties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (nonUpdateableProperties.contains(key)) continue;
                this.properties.put(key, newProperties.get(key));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Updated properties of service {}; new properties: {}", (Object)this.getId(), this.properties);
            }
        }
        this.serviceRegistry.fireServiceChangedEvent(2, this);
    }

    public void unregister() {
        this.serviceRegistry.unregisterService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getId() {
        Dictionary<String, Object> dictionary = this.properties;
        synchronized (dictionary) {
            return (Long)this.properties.get("service.id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRanking() {
        Dictionary<String, Object> dictionary = this.properties;
        synchronized (dictionary) {
            Integer ranking = (Integer)this.properties.get("service.ranking");
            return ranking == null ? 0 : ranking;
        }
    }
}

