/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.emf;

import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.xml.resolver.Catalog;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;

final class Resolver
extends AdapterImpl
implements XSDSchemaLocationResolver {
    private final Log log;
    private final Catalog catalog;

    Resolver(Log log, Catalog catalog) {
        this.log = log;
        this.catalog = catalog;
    }

    public String resolveSchemaLocation(XSDSchema xsdSchema, String namespaceURI, String schemaLocationURI) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Resolving " + schemaLocationURI + " (namespace: " + namespaceURI + ") relative to " + xsdSchema.getSchemaLocation()));
        }
        String location = XSDConstants.resolveSchemaLocation((String)xsdSchema.getSchemaLocation(), (String)namespaceURI, (String)schemaLocationURI);
        if (this.catalog != null) {
            try {
                String altLocation = this.catalog.resolveURI(location);
                if (altLocation == null) {
                    altLocation = this.catalog.resolveURI(namespaceURI);
                }
                if (altLocation != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("Catalog has alternate location for " + location));
                    }
                    location = altLocation;
                }
            }
            catch (IOException ex) {
                this.log.warn((CharSequence)"Failed to resolve URI using catalog", (Throwable)ex);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Resolved schema location: " + location));
        }
        return location;
    }

    public boolean isAdapterForType(Object type) {
        return type == XSDSchemaLocationResolver.class;
    }
}

