/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.emf;

import com.github.veithen.maven.emf.CustomXSDEcoreBuilder;
import com.github.veithen.maven.emf.EMFMojo;
import com.github.veithen.maven.emf.Resolver;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

@Mojo(name="xsd2ecore")
public class XSD2EcoreMojo
extends EMFMojo {
    @Parameter(required=true)
    private File input;
    @Parameter
    private File catalog;
    @Parameter
    private File output;
    @Parameter(defaultValue="${project.build.directory}/model")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean useQualifiedPackageNames;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Catalog catalog;
        if (this.catalog == null) {
            catalog = null;
        } else {
            CatalogManager catalogManager = new CatalogManager();
            catalogManager.setCatalogFiles(this.catalog.getAbsolutePath());
            catalog = catalogManager.getCatalog();
        }
        CustomXSDEcoreBuilder xsdEcoreBuilder = new CustomXSDEcoreBuilder(new Resolver(this.getLog(), catalog));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource commonResource = this.output == null ? null : XSD2EcoreMojo.createXMIResource((ResourceSet)resourceSet, this.output);
        for (EObject element : xsdEcoreBuilder.generate(URI.createFileURI((String)this.input.getAbsolutePath()))) {
            EPackage ePackage = (EPackage)element;
            if (!this.useQualifiedPackageNames) {
                String name = ePackage.getName();
                ePackage.setName(name.substring(name.lastIndexOf(46) + 1));
            }
            Resource resource = commonResource == null ? XSD2EcoreMojo.createXMIResource((ResourceSet)resourceSet, new File(this.outputDirectory, ePackage.getNsPrefix() + ".ecore")) : commonResource;
            resource.getContents().add((Object)element);
        }
        try {
            for (Resource resource : resourceSet.getResources()) {
                resource.save(null);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private static Resource createXMIResource(ResourceSet resourceSet, File file) {
        XMIResourceImpl resource = new XMIResourceImpl(URI.createFileURI((String)file.getAbsolutePath()));
        resourceSet.getResources().add((Object)resource);
        return resource;
    }
}

