/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.hermetic;

import com.github.veithen.maven.hermetic.PolicyWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.SocketPermission;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;

@Mojo(name="generate-policy", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, threadSafe=true)
public final class GeneratePolicyMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="mojoExecution", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.build.directory}/test.policy", required=true)
    private File outputFile;
    @Parameter(defaultValue="${project.build.directory}/secmgr.jar", readonly=true, required=true)
    private File securityManagerJarFile;
    @Parameter(defaultValue="false", required=true)
    private boolean skip;
    @Parameter(defaultValue="false", required=true)
    private boolean debug;
    @Parameter(defaultValue="false", required=true)
    private boolean allowExec;
    @Parameter(defaultValue="false", required=true)
    private boolean allowCrossProjectAccess;
    @Parameter(defaultValue="argLine", required=true)
    private String property;
    @Parameter(defaultValue="true", required=true)
    private boolean append;

    private static File getJavaHome() {
        File javaHome = new File(System.getProperty("java.home"));
        return javaHome.getName().equals("jre") ? javaHome.getParentFile() : javaHome;
    }

    private static boolean isDescendant(File dir, File path) {
        do {
            if (!path.equals(dir)) continue;
            return true;
        } while ((path = path.getParentFile()) != null);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String currentValue;
        File securityManagerJarFile;
        if (this.skip || this.project.getPackaging().equals("pom")) {
            return;
        }
        File projectDir = this.project.getBasedir();
        if (this.allowCrossProjectAccess) {
            File dir2 = projectDir;
            while ((dir2 = dir2.getParentFile()) != null) {
                if (!new File(dir2, "pom.xml").exists()) continue;
                projectDir = dir2;
            }
        }
        this.outputFile.getParentFile().mkdirs();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "utf-8");){
            void var8_17;
            String[] dirs;
            PolicyWriter writer = new PolicyWriter(out);
            writer.start();
            File javaHome = GeneratePolicyMojo.getJavaHome();
            writer.generateDirPermissions(javaHome, Integer.MAX_VALUE, false);
            String extDirs = System.getProperty("java.ext.dirs");
            if (extDirs != null) {
                dirs = Stream.of(extDirs.split(Pattern.quote(File.pathSeparator))).map(File::new).filter(dir -> !GeneratePolicyMojo.isDescendant(javaHome, dir)).collect(Collectors.toList());
                for (File file : dirs) {
                    writer.generateDirPermissions(file, 1, false);
                }
            }
            writer.generateDirPermissions(new File(System.getProperty("maven.home")), 0, false);
            writer.generateDirPermissions(new File(this.session.getSettings().getLocalRepository()), 0, false);
            writer.generateDirPermissions(projectDir, 0, false);
            writer.writePermission(new FilePermission(this.session.getRequest().getUserToolchainsFile().getAbsolutePath(), "read"));
            for (MavenProject project : this.session.getProjects()) {
                File file = project.getArtifact().getFile();
                if (file != null) {
                    writer.writePermission(new FilePermission(file.getAbsolutePath(), "read"));
                }
                for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
                    writer.writePermission(new FilePermission(attachedArtifact.getFile().getAbsolutePath(), "read"));
                }
            }
            dirs = new String[]{this.project.getBuild().getDirectory(), System.getProperty("java.io.tmpdir")};
            int n = dirs.length;
            boolean bl = false;
            while (var8_17 < n) {
                String dir4 = dirs[var8_17];
                writer.generateDirPermissions(new File(dir4), 0, true);
                ++var8_17;
            }
            writer.writePermission(new FilePermission(System.getProperty("user.home"), "read"));
            writer.writePermission(new SocketPermission("localhost", "connect,listen,accept,resolve"));
            if (this.allowExec) {
                writer.writePermission(new FilePermission("<<ALL FILES>>", "execute"));
            }
            writer.end();
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Failed to write %s", this.outputFile), (Throwable)ex);
        }
        DefaultArtifactCoordinate securityManagerArtifact = new DefaultArtifactCoordinate();
        securityManagerArtifact.setGroupId("com.github.veithen");
        securityManagerArtifact.setArtifactId("hermetic-security-manager");
        securityManagerArtifact.setVersion("1.0.0");
        securityManagerArtifact.setExtension("jar");
        try {
            DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            projectBuildingRequest.setRemoteRepositories(this.project.getPluginArtifactRepositories());
            securityManagerJarFile = this.resolver.resolveArtifact((ProjectBuildingRequest)projectBuildingRequest, (ArtifactCoordinate)securityManagerArtifact).getArtifact().getFile();
        }
        catch (ArtifactResolverException ex) {
            throw new MojoFailureException("Unable to resolve artifact", (Throwable)ex);
        }
        Properties props = this.project.getProperties();
        StringBuilder buffer = new StringBuilder();
        if (this.append && (currentValue = props.getProperty(this.property)) != null) {
            buffer.append(currentValue);
            buffer.append(" ");
        }
        buffer.append("-Xbootclasspath/a:");
        buffer.append(securityManagerJarFile.toString());
        buffer.append(" -Djava.security.manager=com.github.veithen.hermetic.HermeticSecurityManager");
        buffer.append(" -Djava.security.policy==");
        buffer.append(this.outputFile.getAbsolutePath().replace('\\', '/'));
        if (this.debug) {
            buffer.append(" -Djava.security.debug=access,failure");
        }
        String value = buffer.toString();
        props.setProperty(this.property, value);
        this.getLog().info((CharSequence)String.format("%s set to %s", this.property, value));
    }
}

