/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Hex;
import org.apache.maven.plugin.MojoFailureException;

final class Source {
    private final File file;
    private final Supplier<File> rootDirSupplier;

    Source(File file, Supplier<File> rootDir) {
        this.file = file;
        this.rootDirSupplier = rootDir;
    }

    String getPathRelativeToRepositoryRoot() {
        File rootDir = this.rootDirSupplier.get();
        File file = this.file;
        LinkedList<String> components = new LinkedList<String>();
        while (!file.equals(rootDir)) {
            components.addFirst(file.getName());
            if ((file = file.getParentFile()) != null) continue;
            throw new IllegalArgumentException(String.format("%s is not a descendant of %s", this.file, rootDir));
        }
        return String.join((CharSequence)"/", components);
    }

    String digest() throws MojoFailureException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new MojoFailureException("Failed to instantiate message digest", (Throwable)ex);
        }
        byte[] buffer = new byte[4096];
        try (FileInputStream in = new FileInputStream(this.file);){
            int c;
            while ((c = in.read(buffer)) != -1) {
                digest.update(buffer, 0, c);
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failed to compute checksum", (Throwable)ex);
        }
        return Hex.encodeHexString((byte[])digest.digest(), (boolean)true);
    }
}

