/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiResult
implements ComparableByContent<MultiResult> {
    private List<CommandResult<?>> results;
    public static SerializationHandle<MultiResult> SERIALIZATION_HANDLE = new SerializationHandle<MultiResult>(){

        @Override
        public <S> MultiResult deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int size = adapter.readInt(input);
            ArrayList results = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                CommandResult<?> result = CommandResult.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
                results.add(result);
            }
            return new MultiResult(results);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, MultiResult multiResult, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, multiResult.results.size());
            for (CommandResult result : multiResult.results) {
                CommandResult.SERIALIZATION_HANDLE.serialize(adapter, output, result, backwardCompatibilityVersion);
            }
        }

        @Override
        public int getTypeId() {
            return 13;
        }

        @Override
        public Class<MultiResult> getSerializedType() {
            return MultiResult.class;
        }
    };

    public MultiResult(List<CommandResult<?>> results) {
        this.results = results;
    }

    public List<CommandResult<?>> getResults() {
        return this.results;
    }

    @Override
    public boolean equalsByContent(MultiResult other) {
        if (this.results.size() != other.results.size()) {
            return false;
        }
        for (int i = 0; i < this.results.size(); ++i) {
            CommandResult<?> result2;
            CommandResult<?> result1 = this.results.get(i);
            if (ComparableByContent.equals(result1, result2 = other.results.get(i))) continue;
            return false;
        }
        return true;
    }
}

