/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.serialization;

import io.github.bucket4j.distributed.serialization.PrimitiveSerializationHandles;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class SerializationHandles {
    private final Collection<SerializationHandle<?>> allHandles;
    private final SerializationHandle[] handlesById;

    public SerializationHandles(Collection<SerializationHandle<?>> allHandles) {
        HashMap serializersById = new HashMap();
        int maxTypeId = 0;
        for (SerializationHandle<?> handle : allHandles) {
            int typeId = handle.getTypeId();
            if (typeId <= 0) {
                throw new IllegalArgumentException("non positive typeId=" + typeId + " detected for " + handle);
            }
            maxTypeId = Math.max(maxTypeId, typeId);
            SerializationHandle conflictingHandle = (SerializationHandle)serializersById.get(typeId);
            if (conflictingHandle != null) {
                String msg = "Serialization ID " + typeId + " duplicated for " + handle + " and " + conflictingHandle;
                throw new IllegalArgumentException(msg);
            }
            serializersById.put(typeId, handle);
        }
        this.allHandles = Collections.unmodifiableCollection(allHandles);
        this.handlesById = new SerializationHandle[maxTypeId + 1];
        Iterator<SerializationHandle<?>> iterator = allHandles.iterator();
        while (iterator.hasNext()) {
            SerializationHandle<?> handle;
            this.handlesById[handle.getTypeId()] = handle = iterator.next();
        }
    }

    public SerializationHandles merge(SerializationHandle<?> ... handles) {
        ArrayList resultHandles = new ArrayList(this.allHandles);
        for (SerializationHandle<?> handle : handles) {
            resultHandles.add(handle);
        }
        return new SerializationHandles(resultHandles);
    }

    public <T> SerializationHandle<T> getHandleByTypeId(int typeId) {
        if (typeId > 0) {
            if (typeId >= this.handlesById.length) {
                throw new UnsupportedTypeException(typeId);
            }
            return this.handlesById[typeId];
        }
        if ((typeId = -typeId) >= PrimitiveSerializationHandles.primitiveHandlesById.length) {
            throw new UnsupportedTypeException(typeId);
        }
        return PrimitiveSerializationHandles.primitiveHandlesById[typeId];
    }

    public Collection<SerializationHandle<?>> getAllHandles() {
        return this.allHandles;
    }
}

