/*
 * Decompiled with CFR 0.152.
 */
package com.github.vsspt.xjc.equals;

import com.github.vsspt.xjc.AbstractVssPluginImpl;
import com.github.vsspt.xjc.annotation.IncludeOnEqualsAndHash;
import com.github.vsspt.xjc.model.ClassRepresentation;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PluginImpl
extends AbstractVssPluginImpl {
    private static final String OPTION_NAME = "XvsEqualsHashCode";
    private static final String USAGE = "XvsEqualsHashCode :  inject equals";
    private static final String OPERATION_EQUALS = "equals";
    private static final String OPERATION_HASH = "hashCode";
    private static final String OPERATION_HASH_METHOD = "hash";
    private static final String OBJ = "obj";
    private static final String OTHER = "other";
    private static final int IDX_TO_REMOVE = 0;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return USAGE;
    }

    @Override
    protected String getAnnotationName() {
        return IncludeOnEqualsAndHash.class.getName();
    }

    @Override
    protected boolean checkAnnotationsFields() {
        return true;
    }

    @Override
    protected void generateMethod(ClassRepresentation clazz, List<JFieldVar> fields, boolean hasSuperClassFields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        JDefinedClass implClass = clazz.getClassOutline().implClass;
        this.createEqualsMethod(implClass, fields, hasSuperClassFields);
        this.createHashCodeMethod(implClass, fields, hasSuperClassFields);
    }

    private void createEqualsMethod(JDefinedClass implClass, List<JFieldVar> fields, boolean isSuperClass) {
        JMethod method = implClass.method(1, (JType)implClass.owner().BOOLEAN, OPERATION_EQUALS);
        method.annotate(Override.class);
        JVar vObj = method.param(Object.class, OBJ);
        JConditional condMe = method.body()._if(JExpr._this().eq((JExpression)vObj));
        condMe._then()._return(JExpr.TRUE);
        JConditional condNull = method.body()._if(vObj.eq(JExpr._null()));
        condNull._then()._return(JExpr.FALSE);
        if (isSuperClass) {
            JConditional condSuper = method.body()._if(JExpr._super().invoke(OPERATION_EQUALS).arg((JExpression)vObj).eq(JExpr.FALSE));
            condSuper._then()._return(JExpr.FALSE);
        }
        JVar vOther = method.body().decl(8, (JType)implClass, OTHER, (JExpression)JExpr.cast((JType)implClass, (JExpression)vObj));
        JClass objectsClass = implClass.owner().ref(Objects.class);
        ArrayList<JFieldVar> clonedList = new ArrayList<JFieldVar>(fields.size());
        clonedList.addAll(fields);
        JFieldVar first = (JFieldVar)clonedList.remove(0);
        JBlock block = new JBlock();
        JInvocation invocation = block.staticInvoke(objectsClass, OPERATION_EQUALS).arg((JExpression)JExpr.ref((String)first.name())).arg((JExpression)vOther.ref(first.name()));
        for (JFieldVar jFieldVar : clonedList) {
            invocation = JOp.cand((JExpression)invocation, (JExpression)block.staticInvoke(objectsClass, OPERATION_EQUALS).arg((JExpression)JExpr.ref((String)jFieldVar.name())).arg((JExpression)vOther.ref(jFieldVar.name())));
        }
        method.body()._return((JExpression)invocation);
    }

    private void createHashCodeMethod(JDefinedClass implClass, List<JFieldVar> fields, boolean isSuperClass) {
        JMethod method = implClass.method(1, (JType)implClass.owner().INT, OPERATION_HASH);
        method.annotate(Override.class);
        JClass objectsClass = implClass.owner().ref(Objects.class);
        JBlock block = new JBlock();
        JInvocation invocation = block.staticInvoke(objectsClass, OPERATION_HASH_METHOD);
        for (JFieldVar jFieldVar : fields) {
            invocation.arg((JExpression)JExpr.ref((String)jFieldVar.name()));
        }
        if (isSuperClass) {
            invocation.arg((JExpression)JExpr._super().invoke(OPERATION_HASH));
        }
        method.body()._return((JExpression)invocation);
    }
}

