/*
 * Decompiled with CFR 0.152.
 */
package com.github.vsspt.xjc.model;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassRepresentation {
    private final ClassOutline classOutline;
    private final String annotationOption;
    private final String name;
    private final List<String> classFields = new ArrayList<String>();
    private final List<String> fieldsFromAnnotations = new ArrayList<String>();
    private final boolean checkAnnotationfields;

    public ClassRepresentation(ClassOutline classOutline, String annotationOption, boolean checkAnnotationfields) {
        this.classOutline = classOutline;
        this.annotationOption = annotationOption;
        this.name = classOutline.implClass.name();
        this.checkAnnotationfields = checkAnnotationfields;
        this.process();
    }

    public ClassOutline getClassOutline() {
        return this.classOutline;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getClassFields() {
        return this.classFields;
    }

    public List<String> getFieldsFromAnnotations() {
        return this.fieldsFromAnnotations;
    }

    public boolean isValidForAugument() {
        return !this.checkAnnotationfields ? true : !this.fieldsFromAnnotations.isEmpty();
    }

    public String toString() {
        return "Name = " + this.name + ", classFields = " + this.classFields + ", fieldsFromAnnotations= " + this.fieldsFromAnnotations;
    }

    private void process() {
        for (JFieldVar jfield : this.classOutline.implClass.fields().values()) {
            Collection annotations = jfield.annotations();
            for (JAnnotationUse annotation : annotations) {
                String fullclassName = annotation.getAnnotationClass().fullName();
                if (!this.isAnnotationEligible(fullclassName) || this.fieldsFromAnnotations.contains(fullclassName)) continue;
                this.fieldsFromAnnotations.add(jfield.name());
            }
            String checkedValue = jfield.name();
            if (this.classFields.contains(checkedValue)) continue;
            this.classFields.add(checkedValue);
        }
    }

    private boolean isAnnotationEligible(String annotationName) {
        return this.annotationOption == null ? false : this.annotationOption.equals(annotationName);
    }
}

