/*
 * Decompiled with CFR 0.152.
 */
package com.github.vsspt.xjc.string;

import com.github.vsspt.xjc.AbstractVssPluginImpl;
import com.github.vsspt.xjc.annotation.ExcludeOnToString;
import com.github.vsspt.xjc.model.ClassRepresentation;
import com.google.common.collect.Iterables;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PluginImpl
extends AbstractVssPluginImpl {
    private static final String OPTION_NAME = "XvsToString";
    private static final String USAGE = "XvsToString :  inject ToString";
    private static final String OPERATION = "toString";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return USAGE;
    }

    @Override
    protected String getAnnotationName() {
        return ExcludeOnToString.class.getName();
    }

    @Override
    protected boolean checkAnnotationsFields() {
        return false;
    }

    @Override
    protected void generateMethod(ClassRepresentation clazz, List<JFieldVar> excludeFields, boolean hasSuperClassFields) {
        JDefinedClass implClass = clazz.getClassOutline().implClass;
        JMethod method = implClass.method(1, String.class, OPERATION);
        method.annotate(Override.class);
        JInvocation invocation = null;
        if (hasSuperClassFields) {
            invocation = JExpr._super().invoke(OPERATION);
        }
        ArrayList clonedList = new ArrayList();
        Collection fields = implClass.fields().values();
        if (fields != null && !fields.isEmpty()) {
            clonedList.addAll(implClass.fields().values());
            JFieldVar last = (JFieldVar)Iterables.getLast(clonedList);
            for (JFieldVar field : clonedList) {
                String lastChar;
                if (excludeFields != null && excludeFields.contains(field)) continue;
                String string = lastChar = field.name().equals(last.name()) ? ") " : "), ";
                if (invocation != null) {
                    invocation = JOp.plus((JExpression)invocation, (JExpression)JExpr.lit((String)("(" + field.name() + " = "))).plus((JExpression)JExpr.ref((String)field.name())).plus(JExpr.lit((String)lastChar));
                    continue;
                }
                invocation = JExpr.lit((String)("(" + field.name() + " = ")).plus((JExpression)JExpr.ref((String)field.name())).plus(JExpr.lit((String)lastChar));
            }
        }
        JInvocation returnValue = invocation == null ? JExpr.lit((String)"") : invocation;
        method.body()._return((JExpression)returnValue);
    }
}

