/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tinyradius.attribute.AttributeType;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;

public class Attributes {
    public static RadiusAttribute createAttribute(Dictionary dictionary, int vendorId, int type, byte[] data) {
        AttributeType attributeType = dictionary.getAttributeTypeByCode(vendorId, type);
        if (attributeType != null) {
            return attributeType.create(dictionary, data);
        }
        return new RadiusAttribute(dictionary, vendorId, type, data);
    }

    public static RadiusAttribute createAttribute(Dictionary dictionary, int vendorId, int type, String data) {
        AttributeType attributeType = dictionary.getAttributeTypeByCode(vendorId, type);
        if (attributeType != null) {
            return attributeType.create(dictionary, data);
        }
        return new RadiusAttribute(dictionary, vendorId, type, data);
    }

    public static List<RadiusAttribute> extractAttributes(Dictionary dictionary, int vendorId, byte[] data, int pos) {
        ArrayList<RadiusAttribute> attributes = new ArrayList<RadiusAttribute>();
        while (data.length - pos >= 2) {
            int type = Byte.toUnsignedInt(data[pos]);
            int length = Byte.toUnsignedInt(data[pos + 1]);
            int expectedLen = length - 2;
            if (expectedLen < 0) {
                throw new IllegalArgumentException("invalid attribute length " + length + ", must be >=2");
            }
            if (expectedLen > data.length - pos) {
                throw new IllegalArgumentException("invalid attribute length " + length + ", remaining bytes " + (data.length - pos));
            }
            attributes.add(Attributes.createAttribute(dictionary, vendorId, type, Arrays.copyOfRange(data, pos + 2, pos + length)));
            pos += length;
        }
        if (pos != data.length) {
            throw new IllegalArgumentException("attribute malformed");
        }
        return attributes;
    }
}

