/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.nio.ByteBuffer;
import org.tinyradius.attribute.AttributeType;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;

public class IntegerAttribute
extends RadiusAttribute {
    IntegerAttribute(Dictionary dictionary, int vendorId, int type, byte[] data) {
        super(dictionary, vendorId, type, data);
        if (data.length != 4) {
            throw new IllegalArgumentException("integer attribute value should be 4 octets, actual: " + data.length);
        }
    }

    IntegerAttribute(Dictionary dictionary, int vendorId, int type, String value) {
        this(dictionary, vendorId, type, IntegerAttribute.convertValue(value, dictionary, type, vendorId));
    }

    public IntegerAttribute(Dictionary dictionary, int vendorId, int type, int value) {
        this(dictionary, vendorId, type, IntegerAttribute.convertValue(value));
    }

    public long getValueLong() {
        return Integer.toUnsignedLong(this.getValueInt());
    }

    public int getValueInt() {
        return ByteBuffer.wrap(this.getValue()).getInt();
    }

    @Override
    public String getValueString() {
        String name;
        int value = this.getValueInt();
        AttributeType at = this.getAttributeType();
        if (at != null && (name = at.getEnumeration(value)) != null) {
            return name;
        }
        return Integer.toUnsignedString(value);
    }

    private static byte[] convertValue(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    private static int convertValue(String value, Dictionary dictionary, int attributeType, int vendorId) {
        Integer val;
        AttributeType at = dictionary.getAttributeTypeByCode(vendorId, attributeType);
        if (at != null && (val = at.getEnumeration(value)) != null) {
            return val;
        }
        return Integer.parseUnsignedInt(value);
    }
}

