/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;

public class Ipv6PrefixAttribute
extends RadiusAttribute {
    private final String prefix;

    Ipv6PrefixAttribute(Dictionary dictionary, int vendorId, int type, byte[] data) {
        this(dictionary, vendorId, type, Ipv6PrefixAttribute.convertValue(data), Byte.toUnsignedInt(data[1]));
    }

    Ipv6PrefixAttribute(Dictionary dictionary, int vendorId, int type, String value) {
        this(dictionary, vendorId, type, Ipv6PrefixAttribute.convertValue(value), Integer.parseInt(value.split("/")[1]));
    }

    private Ipv6PrefixAttribute(Dictionary dictionary, int vendorId, int type, InetAddress address, int prefixLength) {
        super(dictionary, vendorId, type, Ipv6PrefixAttribute.convertAndCheck(address, prefixLength));
        this.prefix = address.getHostAddress() + "/" + prefixLength;
    }

    @Override
    public String getValueString() {
        return this.prefix;
    }

    private static byte[] convertAndCheck(InetAddress address, int prefixLength) {
        if (prefixLength > 128 || prefixLength < 0) {
            throw new IllegalArgumentException("IPv6 Prefix Prefix-Length should be between 0 and 128, declared: " + prefixLength);
        }
        BitSet bitSet = BitSet.valueOf(address.getAddress());
        int bitSetLength = bitSet.length();
        if (bitSetLength > prefixLength) {
            throw new IllegalArgumentException("Prefix-Length is " + prefixLength + ", actual address has prefix length " + bitSetLength + ", bits outside of the Prefix-Length must be zero.");
        }
        int prefixBytes = (int)Math.ceil((double)prefixLength / 8.0);
        byte[] addressBytes = bitSet.toByteArray();
        return ByteBuffer.allocate(2 + prefixBytes).put((byte)0).put((byte)prefixLength).put(addressBytes).array();
    }

    private static InetAddress convertValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid IPv6 prefix, empty: " + value);
        }
        try {
            String[] tokens = value.split("/");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid IPv6 prefix expression, should be in format 'prefix/length': " + value);
            }
            return InetAddress.getByName(tokens[0]);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("bad IPv6 prefix, invalid IPv6 address: " + value, e);
        }
    }

    private static InetAddress convertValue(byte[] data) {
        if (data.length < 2 || data.length > 18) {
            throw new IllegalArgumentException("IPv6 Prefix body should be 2-18 octets (2-octet header + max 16 octet address), actual: " + data.length);
        }
        int availablePrefixBits = (data.length - 2) * 8;
        int prefixLength = Byte.toUnsignedInt(data[1]);
        if (availablePrefixBits < prefixLength) {
            throw new IllegalArgumentException("IPv6 Prefix Prefix-Length declared " + prefixLength + " bits, actual byte array only has space for " + availablePrefixBits + " bits");
        }
        try {
            byte[] array = ByteBuffer.allocate(16).put(data, 2, data.length - 2).array();
            return InetAddress.getByAddress(array);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("bad IPv6 prefix, invalid IPv6 address: " + Arrays.toString(Arrays.copyOfRange(data, 2, data.length)), e);
        }
    }
}

