/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.tinyradius.attribute.AttributeType;
import org.tinyradius.dictionary.Dictionary;

public class RadiusAttribute {
    private final Dictionary dictionary;
    private final int type;
    private final byte[] value;
    private final int vendorId;

    RadiusAttribute(Dictionary dictionary, int vendorId, int type, byte[] value) {
        this.dictionary = Objects.requireNonNull(dictionary, "dictionary not set");
        this.vendorId = vendorId;
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException("attribute type invalid: " + type);
        }
        this.type = type;
        Objects.requireNonNull(value, "attribute data not set");
        if (value.length > 253) {
            throw new IllegalArgumentException("attribute data too long, max 253 octets, actual: " + value.length);
        }
        this.value = value;
    }

    RadiusAttribute(Dictionary dictionary, int vendorId, int type, String value) {
        this(dictionary, vendorId, type, DatatypeConverter.parseHexBinary((String)value));
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public String getValueString() {
        return DatatypeConverter.printHexBinary((byte[])this.value);
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public byte[] toByteArray() {
        byte[] attr = new byte[2 + this.value.length];
        attr[0] = (byte)this.getType();
        attr[1] = (byte)(2 + this.value.length);
        System.arraycopy(this.value, 0, attr, 2, this.value.length);
        return attr;
    }

    public String toString() {
        return this.getAttributeKey() + ": " + this.getValueString();
    }

    public String getAttributeKey() {
        AttributeType at = this.getAttributeType();
        if (at != null) {
            return at.getName();
        }
        if (this.getVendorId() != -1) {
            return "Unknown-Sub-Attribute-" + this.getType();
        }
        return "Unknown-Attribute-" + this.getType();
    }

    public Map<String, String> toAttributeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getAttributeKey(), this.getValueString());
        return map;
    }

    public AttributeType getAttributeType() {
        return this.dictionary.getAttributeTypeByCode(this.getVendorId(), this.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadiusAttribute that = (RadiusAttribute)o;
        return this.type == that.type && this.vendorId == that.vendorId && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.vendorId);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }
}

