/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.concurrent.Promise;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.attribute.Attributes;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.client.PendingRequestCtx;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusPacketException;

public class PromiseAdapter
extends MessageToMessageCodec<RadiusPacket, PendingRequestCtx> {
    private static final Logger logger = LoggerFactory.getLogger(PromiseAdapter.class);
    private static final int PROXY_STATE = 33;
    private final AtomicInteger proxyIndex = new AtomicInteger(1);
    private final Map<String, Request> requests = new ConcurrentHashMap<String, Request>();

    private String nextProxyStateId() {
        return Integer.toString(this.proxyIndex.getAndIncrement());
    }

    protected void encode(ChannelHandlerContext ctx, PendingRequestCtx msg, List<Object> out) {
        RadiusPacket packet = msg.getRequest().copy();
        String requestId = this.nextProxyStateId();
        packet.addAttribute(Attributes.createAttribute(packet.getDictionary(), -1, 33, requestId.getBytes(StandardCharsets.UTF_8)));
        RadiusPacket encodedRequest = packet.encodeRequest(msg.getEndpoint().getSecret());
        this.requests.put(requestId, new Request(msg.getEndpoint().getSecret(), encodedRequest.getAuthenticator(), encodedRequest.getIdentifier(), msg.getResponse()));
        msg.getResponse().addListener(f -> this.requests.remove(requestId));
        out.add(new PendingRequestCtx(encodedRequest, msg.getEndpoint(), msg.getResponse()));
    }

    protected void decode(ChannelHandlerContext ctx, RadiusPacket msg, List<Object> out) {
        List<RadiusAttribute> proxyStates = msg.getAttributes(33);
        if (proxyStates.isEmpty()) {
            logger.warn("Ignoring response - no Proxy-State attribute");
            return;
        }
        RadiusAttribute proxyState = proxyStates.get(proxyStates.size() - 1);
        String proxyStateId = new String(proxyState.getValue(), StandardCharsets.UTF_8);
        Request request = this.requests.get(proxyStateId);
        if (request == null) {
            logger.warn("Ignoring response - request context not found");
            return;
        }
        if (msg.getIdentifier() != request.identifier) {
            logger.warn("Ignoring response - identifier mismatch, request ID {}}, response ID {}", (Object)request.identifier, (Object)msg.getIdentifier());
            return;
        }
        try {
            msg.verify(request.secret, request.authenticator);
        }
        catch (RadiusPacketException e) {
            logger.warn(e.getMessage());
            return;
        }
        msg.removeLastAttribute(33);
        logger.info("Found request for response identifier => {}", (Object)msg.getIdentifier());
        request.promise.trySuccess((Object)msg);
    }

    private static class Request {
        private final String secret;
        private final byte[] authenticator;
        private final int identifier;
        private final Promise<RadiusPacket> promise;

        Request(String secret, byte[] authenticator, int identifier, Promise<RadiusPacket> promise) {
            this.secret = secret;
            this.authenticator = authenticator;
            this.identifier = identifier;
            this.promise = promise;
        }
    }
}

