/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.packet.PacketEncoder;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.server.RequestCtx;
import org.tinyradius.server.ResponseCtx;
import org.tinyradius.server.SecretProvider;
import org.tinyradius.util.RadiusEndpoint;
import org.tinyradius.util.RadiusPacketException;

@ChannelHandler.Sharable
public class ServerPacketCodec
extends MessageToMessageCodec<DatagramPacket, ResponseCtx> {
    private static final Logger logger = LoggerFactory.getLogger(ServerPacketCodec.class);
    private final PacketEncoder packetEncoder;
    private final SecretProvider secretProvider;

    public ServerPacketCodec(PacketEncoder packetEncoder, SecretProvider secretProvider) {
        this.packetEncoder = packetEncoder;
        this.secretProvider = secretProvider;
    }

    protected RequestCtx decodePacket(DatagramPacket msg) {
        InetSocketAddress remoteAddress = (InetSocketAddress)msg.sender();
        String secret = this.secretProvider.getSharedSecret(remoteAddress);
        if (secret == null) {
            logger.warn("Ignoring request from {}, shared secret lookup failed", (Object)remoteAddress);
            return null;
        }
        try {
            RadiusPacket packet = this.packetEncoder.fromDatagram(msg, secret);
            logger.debug("Received packet from {} - {}", (Object)remoteAddress, (Object)packet);
            return new RequestCtx(packet, new RadiusEndpoint(remoteAddress, secret));
        }
        catch (RadiusPacketException e) {
            logger.warn("Could not decode Radius packet: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected DatagramPacket encodePacket(InetSocketAddress localAddress, ResponseCtx msg) {
        RadiusPacket packet = msg.getResponse().encodeResponse(msg.getEndpoint().getSecret(), msg.getRequest().getAuthenticator());
        try {
            DatagramPacket datagramPacket = this.packetEncoder.toDatagram(packet, msg.getEndpoint().getAddress(), localAddress);
            logger.debug("Sending response to {}", (Object)msg.getEndpoint().getAddress());
            return datagramPacket;
        }
        catch (RadiusPacketException e) {
            logger.warn("Could not encode Radius packet: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) {
        RequestCtx requestCtx = this.decodePacket(msg);
        if (requestCtx != null) {
            out.add(requestCtx);
        }
    }

    protected void encode(ChannelHandlerContext ctx, ResponseCtx msg, List<Object> out) {
        DatagramPacket datagramPacket = this.encodePacket((InetSocketAddress)ctx.channel().localAddress(), msg);
        if (datagramPacket != null) {
            out.add(datagramPacket);
        }
    }
}

