/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj;

import com.github.yingzhuo.nsqj.Publisher;
import com.github.yingzhuo.nsqj.SubConnection;
import com.github.yingzhuo.nsqj.Subscriber;
import com.github.yingzhuo.nsqj.Util;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private final Set<Publisher> publishers = new CopyOnWriteArraySet<Publisher>();
    private final Set<Subscriber> subscribers = new CopyOnWriteArraySet<Subscriber>();
    private final Set<SubConnection> subConnections = new CopyOnWriteArraySet<SubConnection>();
    private final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final Object subConMonitor = new Object();
    private final ScheduledExecutorService schedExecutor = Executors.newScheduledThreadPool(2, Util.threadFactory("nsq-sched"));
    private ExecutorService handlerExecutor;
    private SSLSocketFactory sslSocketFactory;
    private byte[] authSecret;
    private static final Client defaultClient = new Client();

    public static Client getDefaultClient() {
        return defaultClient;
    }

    public synchronized boolean stop() {
        return this.stop(2000);
    }

    public synchronized boolean stop(int n) {
        Util.checkArgument(n > 0);
        log.info("stopping nsq client");
        boolean bl = true;
        long l = Util.clock();
        bl &= this.stopSubscribers(n);
        if (this.handlerExecutor != null && !this.handlerExecutor.isTerminated()) {
            int n2 = Math.max((int)((long)n - (Util.clock() - l)), 100);
            bl &= Util.shutdownAndAwaitTermination(this.handlerExecutor, n2, TimeUnit.MILLISECONDS);
        }
        for (Publisher publisher : this.publishers) {
            publisher.stop();
        }
        int n3 = Math.max((int)((long)n - (Util.clock() - l)), 100);
        log.debug("handlerExecutor.isTerminated:{} schedExecutor.isTerminated:{} isClean:{}", new Object[]{this.handlerExecutor != null ? Boolean.valueOf(this.handlerExecutor.isTerminated()) : "null", this.schedExecutor.isTerminated(), bl &= Util.shutdownAndAwaitTermination(this.schedExecutor, n3, TimeUnit.MILLISECONDS)});
        log.info("nsq client stopped");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stopSubscribers(int n) {
        Util.checkArgument(n > 0);
        for (Subscriber object : this.subscribers) {
            object.stop();
        }
        Object object = this.subConMonitor;
        synchronized (object) {
            if (!this.subConnections.isEmpty()) {
                log.info("waiting for subscribers to finish in-flight messages");
                try {
                    this.subConMonitor.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        boolean bl = this.subConnections.isEmpty();
        for (SubConnection subConnection : this.subConnections) {
            subConnection.close();
        }
        return bl;
    }

    public synchronized void setExecutor(ExecutorService executorService) {
        Util.checkNotNull(executorService);
        Util.checkState(this.handlerExecutor == null, "executor can only be set once, must be set before subscribing");
        this.handlerExecutor = executorService;
    }

    public synchronized ExecutorService getExecutor() {
        if (this.handlerExecutor == null) {
            this.handlerExecutor = Executors.newFixedThreadPool(6, Util.threadFactory("nsq-sub"));
        }
        return this.handlerExecutor;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public synchronized byte[] getAuthSecret() {
        return this.authSecret;
    }

    public synchronized void setAuthSecret(byte[] byArray) {
        this.authSecret = byArray;
    }

    public synchronized void setAuthSecret(String string) {
        this.authSecret = string.getBytes();
    }

    void addPublisher(Publisher publisher) {
        this.publishers.add(publisher);
    }

    void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    void addSubConnection(SubConnection subConnection) {
        this.subConnections.add(subConnection);
    }

    ScheduledExecutorService getSchedExecutor() {
        return this.schedExecutor;
    }

    ScheduledFuture scheduleAtFixedRate(final Runnable runnable, int n, int n2, boolean bl) {
        if (bl) {
            n = (int)((double)n * 0.1 + Math.random() * (double)n * 0.9);
        }
        return this.schedExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    log.error("task error", throwable);
                }
            }
        }, n, n2, TimeUnit.MILLISECONDS);
    }

    void schedule(final Runnable runnable, int n) {
        this.schedExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    log.error("task error", throwable);
                }
            }
        }, (long)n, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(SubConnection subConnection) {
        Object object = this.subConMonitor;
        synchronized (object) {
            this.subConnections.remove(subConnection);
            if (this.subConnections.isEmpty()) {
                this.subConMonitor.notifyAll();
            }
        }
    }

    Gson getGson() {
        return this.gson;
    }
}

