/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj;

import com.github.yingzhuo.nsqj.BackoffHandler;
import com.github.yingzhuo.nsqj.BasePubSub;
import com.github.yingzhuo.nsqj.Client;
import com.github.yingzhuo.nsqj.FailedMessageHandler;
import com.github.yingzhuo.nsqj.HostAndPort;
import com.github.yingzhuo.nsqj.Message;
import com.github.yingzhuo.nsqj.MessageDataHandler;
import com.github.yingzhuo.nsqj.MessageHandler;
import com.github.yingzhuo.nsqj.Subscription;
import com.github.yingzhuo.nsqj.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Subscriber
extends BasePubSub {
    private static final Logger log = LoggerFactory.getLogger(Subscriber.class);
    private final List<HostAndPort> lookups = new ArrayList<HostAndPort>();
    private final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private final int lookupIntervalSecs;
    private int maxLookupFailuresBeforeError;
    private int defaultMaxInFlight = 200;
    private int maxFlushDelayMillis = 2000;
    private int maxAttempts = Integer.MAX_VALUE;
    private FailedMessageHandler failedMessageHandler = null;
    private final Map<String, Integer> failures = new HashMap<String, Integer>();
    private static final int DEFAULT_LOOKUP_INTERVAL_SECS = 60;
    private static final int DEFAULT_MAX_LOOKUP_FAILURES_BEFORE_ERROR = 5;

    public Subscriber(Client client, int n, int n2, String ... stringArray) {
        super(client);
        Util.checkArgument(n > 0);
        this.lookupIntervalSecs = n;
        this.maxLookupFailuresBeforeError = n2;
        client.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Subscriber.this.lookup();
            }
        }, n * 1000, n * 1000, true);
        for (String string : stringArray) {
            this.lookups.add(HostAndPort.fromString(string).withDefaultPort(4161));
        }
    }

    public Subscriber(int n, int n2, String ... stringArray) {
        this(Client.getDefaultClient(), n, n2, stringArray);
    }

    public Subscriber(int n, String ... stringArray) {
        this(Client.getDefaultClient(), n, 5, stringArray);
    }

    public Subscriber(String ... stringArray) {
        this(Client.getDefaultClient(), 60, 5, stringArray);
    }

    public synchronized void subscribe(String string, String string2, MessageHandler messageHandler) {
        this.subscribe(string, string2, this.defaultMaxInFlight, messageHandler);
    }

    public synchronized void subscribe(String string, String string2, final MessageDataHandler messageDataHandler) {
        this.subscribe(string, string2, this.defaultMaxInFlight, new BackoffHandler(new MessageHandler(){

            @Override
            public void accept(Message message) {
                messageDataHandler.accept(message.getData());
            }
        }));
    }

    public synchronized void subscribe(String string, String string2, int n, MessageHandler messageHandler) {
        Util.checkNotNull(string);
        Util.checkNotNull(string2);
        Util.checkNotNull(messageHandler);
        this.client.addSubscriber(this);
        Subscription subscription = new Subscription(this.client, string, string2, messageHandler, this, n);
        if (messageHandler instanceof BackoffHandler) {
            ((BackoffHandler)messageHandler).setSubscription(subscription);
        }
        this.subscriptions.add(subscription);
        subscription.checkConnections(this.lookupTopic(string));
    }

    public synchronized void setMaxInFlight(String string, String string2, int n) {
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.getTopic().equals(string) || !subscription.getChannel().equals(string2)) continue;
            subscription.setMaxInFlight(n);
        }
    }

    private synchronized void lookup() {
        if (this.isStopping) {
            return;
        }
        for (Subscription subscription : this.subscriptions) {
            subscription.checkConnections(this.lookupTopic(subscription.getTopic()));
        }
    }

    /*
     * Exception decompiling
     */
    @GuardedBy(value="this")
    protected Set<HostAndPort> lookupTopic(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void stop() {
        super.stop();
        for (Subscription subscription : this.subscriptions) {
            subscription.stop();
        }
        log.info("subscriber stopped");
    }

    public synchronized int getDefaultMaxInFlight() {
        return this.defaultMaxInFlight;
    }

    public synchronized void setDefaultMaxInFlight(int n) {
        this.defaultMaxInFlight = n;
    }

    public synchronized int getMaxFlushDelayMillis() {
        return this.maxFlushDelayMillis;
    }

    public synchronized void setMaxFlushDelayMillis(int n) {
        this.maxFlushDelayMillis = n;
    }

    public synchronized int getMaxAttempts() {
        return this.maxAttempts;
    }

    public synchronized void setMaxAttempts(int n) {
        this.maxAttempts = n;
    }

    public synchronized FailedMessageHandler getFailedMessageHandler() {
        return this.failedMessageHandler;
    }

    public synchronized void setFailedMessageHandler(FailedMessageHandler failedMessageHandler) {
        this.failedMessageHandler = failedMessageHandler;
    }

    public synchronized int getLookupIntervalSecs() {
        return this.lookupIntervalSecs;
    }

    public Integer getExecutorQueueSize() {
        ExecutorService executorService = this.client.getExecutor();
        return executorService instanceof ThreadPoolExecutor ? Integer.valueOf(((ThreadPoolExecutor)executorService).getQueue().size()) : null;
    }

    public synchronized int getConnectionCount() {
        int n = 0;
        for (Subscription subscription : this.subscriptions) {
            n += subscription.getConnectionCount();
        }
        return n;
    }
}

