/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj.springboot.autoconfig;

import com.github.yingzhuo.nsqj.Config;
import com.github.yingzhuo.nsqj.spring.PublisherConfigurer;
import com.github.yingzhuo.nsqj.spring.PublisherFactoryBean;
import com.github.yingzhuo.nsqj.spring.config.BatchConfig;
import com.github.yingzhuo.nsqj.springboot.autoconfig.NsqSpringBootAutoConfigBasic;
import com.github.yingzhuo.nsqj.springboot.autoconfig.props.NsqProducerProps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={NsqProducerProps.class})
@AutoConfigureAfter(value={NsqSpringBootAutoConfigBasic.class})
@ConditionalOnProperty(prefix="nsq.publisher", name={"enabled"}, havingValue="true")
public class NsqSpringBootAutoConfigPublisher {
    @Autowired(required=false)
    private PublisherConfigurer publisherConfigurer;

    @Bean
    @ConfigurationPropertiesBinding
    public BatchConfig.BatchConfigConverter batchConfigConverter() {
        return new BatchConfig.BatchConfigConverter();
    }

    @Bean
    public PublisherFactoryBean publisher(NsqProducerProps nsqProducerProps) {
        PublisherFactoryBean publisherFactoryBean = new PublisherFactoryBean();
        publisherFactoryBean.setBatchConfigs(nsqProducerProps.getBatchConfigs());
        publisherFactoryBean.setNsqd(nsqProducerProps.getNsqdHost());
        publisherFactoryBean.setFailoverNsqd(nsqProducerProps.getFailoverNsqdHost());
        publisherFactoryBean.setFailoverDurationSecs(nsqProducerProps.getFailoverDurationSecs());
        publisherFactoryBean.setPublisherConfigurer(this.publisherConfigurer);
        Config config = new Config();
        config.setClientId(nsqProducerProps.getConfig().getClientId());
        config.setHostname(nsqProducerProps.getConfig().getHostname());
        config.setHeartbeatInterval(nsqProducerProps.getConfig().getHeartbeatInterval());
        config.setOutputBufferSize(nsqProducerProps.getConfig().getOutputBufferSize());
        config.setOutputBufferTimeout(nsqProducerProps.getConfig().getOutputBufferTimeout());
        config.setTlsV1(nsqProducerProps.getConfig().getTlsV1());
        config.setSnappy(nsqProducerProps.getConfig().getSnappy());
        config.setDeflate(nsqProducerProps.getConfig().getDeflate());
        config.setSampleRate(nsqProducerProps.getConfig().getSampleRate());
        config.setMsgTimeout(nsqProducerProps.getConfig().getMsgTimeout());
        config.setFeatureNegotiation(nsqProducerProps.getConfig().getFeatureNegotiation());
        config.setUserAgent(nsqProducerProps.getConfig().getUserAgent());
        publisherFactoryBean.setConfig(config);
        return publisherFactoryBean;
    }
}

