/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj.springboot.autoconfig.props;

import com.github.yingzhuo.nsqj.spring.config.BatchConfig;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="nsq.publisher")
public class NsqProducerProps
implements InitializingBean {
    private boolean enabled = false;
    private String nsqdHost;
    private String failoverNsqdHost;
    private List<BatchConfig> batchConfigs;
    private ConfigProps config = new ConfigProps();
    private int FailoverDurationSecs = 300;

    public void afterPropertiesSet() {
        if (this.enabled) {
            Assert.hasText((String)this.getNsqdHost(), (String)null);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getNsqdHost() {
        return this.nsqdHost;
    }

    public String getFailoverNsqdHost() {
        return this.failoverNsqdHost;
    }

    public List<BatchConfig> getBatchConfigs() {
        return this.batchConfigs;
    }

    public ConfigProps getConfig() {
        return this.config;
    }

    public int getFailoverDurationSecs() {
        return this.FailoverDurationSecs;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setNsqdHost(String string) {
        this.nsqdHost = string;
    }

    public void setFailoverNsqdHost(String string) {
        this.failoverNsqdHost = string;
    }

    public void setBatchConfigs(List<BatchConfig> list) {
        this.batchConfigs = list;
    }

    public void setConfig(ConfigProps configProps) {
        this.config = configProps;
    }

    public void setFailoverDurationSecs(int n) {
        this.FailoverDurationSecs = n;
    }

    @ConfigurationProperties(prefix="nsq.publisher.config")
    public static class ConfigProps {
        private String clientId;
        private String hostname;
        private Integer heartbeatInterval;
        private Integer outputBufferSize;
        private Integer outputBufferTimeout;
        private Boolean tlsV1;
        private Boolean snappy;
        private Boolean deflate;
        private Integer deflateLevel;
        private Integer sampleRate;
        private Integer msgTimeout;
        private Boolean featureNegotiation = true;
        private String userAgent = "nsq-j/1.0";

        public String getClientId() {
            return this.clientId;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public Integer getOutputBufferSize() {
            return this.outputBufferSize;
        }

        public Integer getOutputBufferTimeout() {
            return this.outputBufferTimeout;
        }

        public Boolean getTlsV1() {
            return this.tlsV1;
        }

        public Boolean getSnappy() {
            return this.snappy;
        }

        public Boolean getDeflate() {
            return this.deflate;
        }

        public Integer getDeflateLevel() {
            return this.deflateLevel;
        }

        public Integer getSampleRate() {
            return this.sampleRate;
        }

        public Integer getMsgTimeout() {
            return this.msgTimeout;
        }

        public Boolean getFeatureNegotiation() {
            return this.featureNegotiation;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setClientId(String string) {
            this.clientId = string;
        }

        public void setHostname(String string) {
            this.hostname = string;
        }

        public void setHeartbeatInterval(Integer n) {
            this.heartbeatInterval = n;
        }

        public void setOutputBufferSize(Integer n) {
            this.outputBufferSize = n;
        }

        public void setOutputBufferTimeout(Integer n) {
            this.outputBufferTimeout = n;
        }

        public void setTlsV1(Boolean bl) {
            this.tlsV1 = bl;
        }

        public void setSnappy(Boolean bl) {
            this.snappy = bl;
        }

        public void setDeflate(Boolean bl) {
            this.deflate = bl;
        }

        public void setDeflateLevel(Integer n) {
            this.deflateLevel = n;
        }

        public void setSampleRate(Integer n) {
            this.sampleRate = n;
        }

        public void setMsgTimeout(Integer n) {
            this.msgTimeout = n;
        }

        public void setFeatureNegotiation(Boolean bl) {
            this.featureNegotiation = bl;
        }

        public void setUserAgent(String string) {
            this.userAgent = string;
        }
    }
}

