/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuchi.semver;

import com.github.yuchi.semver.Direction;
import com.github.yuchi.semver.Range;
import com.github.yuchi.semver.Version;

public class SemVer {
    public static boolean isGreaterThenRange(Object version, Object range) {
        return SemVer.isGreaterThenRange(version, range, false);
    }

    public static boolean isGreaterThenRange(Object version, Object range, boolean loose) {
        return SemVer.isOutside(version, range, Direction.HIGH, loose);
    }

    public static boolean isOutside(Object version, Object range, Direction dir, boolean loose) {
        Version _version = Version.from(version, loose);
        Range _range = Range.from(range, loose);
        return _range.isOutside(_version, dir);
    }

    public static boolean isLessThenRange(Object version, Object range) {
        return SemVer.isLessThenRange(version, range, false);
    }

    public static boolean isLessThenRange(Object version, Object range, boolean loose) {
        return SemVer.isOutside(version, range, Direction.LOW, loose);
    }

    public static String valid(Object version) {
        return SemVer.valid(version, false);
    }

    public static String valid(Object version, boolean loose) {
        Version _version = Version.from(version, loose);
        if (_version != null) {
            return _version.version;
        }
        return null;
    }

    public static String validRange(Object range) {
        return SemVer.validRange(range, false);
    }

    public static String validRange(Object range, boolean loose) {
        Range _range = Range.from(range, loose);
        if (_range != null) {
            return _range.raw;
        }
        return null;
    }
}

