/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public class ExceptionHelper
extends Throwable {
    private static final long serialVersionUID = 1L;
    private final List<String> trace;
    private final String className;
    private final String exceptionMessage;

    public List<String> getTrace() {
        return this.trace;
    }

    public String getClassName() {
        return this.className;
    }

    public ExceptionHelper(String exceptionClass, String exceptionMessage, List<String> trace) {
        if (exceptionClass == null || trace == null || trace.size() < 1 || exceptionClass.length() < 1) {
            throw new IllegalArgumentException("className oder trace war null oder leer");
        }
        this.className = exceptionClass;
        this.exceptionMessage = exceptionMessage;
        this.trace = trace;
    }

    public ExceptionHelper(String exceptionClass, List<String> trace) {
        this(exceptionClass, null, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this.className);
            for (String traceLine : this.trace) {
                s.println(this.removeNullAndBeginningTag(traceLine));
            }
        }
    }

    private String removeNullAndBeginningTag(String string) {
        if (string == null) {
            return "";
        }
        return string.startsWith("\t") && string.length() > 1 ? string.substring(1) : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this.toString());
            for (String traceLine : this.trace) {
                s.println(this.removeNullAndBeginningTag(traceLine));
            }
        }
    }

    @Override
    public String toString() {
        return this.exceptionMessage != null ? this.className + ": " + this.exceptionMessage : this.className;
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public Throwable getCause() {
        return null;
    }

    @Override
    public String getLocalizedMessage() {
        return this.exceptionMessage;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return new StackTraceElement[0];
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        return this;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
    }
}

