/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ExtraInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long maxMemory;
    private final long currentTimeMillis;
    private final HashMap<String, String> props;

    public ExtraInfo() {
        this.props = new HashMap();
        try {
            Properties properties = System.getProperties();
            Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                Object value = entry.getValue();
                Object key = entry.getKey();
                if (value == null || key == null) continue;
                this.props.put(key.toString(), value.toString());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.currentTimeMillis = System.currentTimeMillis();
    }

    public ExtraInfo(long maxMemory, long currentTimeMillis, HashMap<String, String> props) {
        this.maxMemory = maxMemory;
        this.currentTimeMillis = currentTimeMillis;
        this.props = props;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getCurrentTimeMillis() {
        return this.currentTimeMillis;
    }

    public HashMap<String, String> getProps() {
        return this.props;
    }

    public static void main(String[] args) {
        ExtraInfo extraInfo = new ExtraInfo();
        for (Map.Entry<String, String> entry : extraInfo.getProps().entrySet()) {
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        System.out.println("Mem: " + extraInfo.getMaxMemory());
        System.out.println("Time: " + extraInfo.getCurrentTimeMillis());
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 12345L;
        private transient ExtraInfo extraInfo;

        public SerializationProxy(ExtraInfo extraInfo) {
            this.extraInfo = extraInfo;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(3);
            s.writeObject(this.extraInfo.getProps());
            s.writeLong(this.extraInfo.getCurrentTimeMillis());
            s.writeLong(this.extraInfo.getMaxMemory());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            int felderImStrom = s.readInt();
            HashMap<String, String> props = this.read(s, felderImStrom, 1, new HashMap());
            long currentTimeInMillies = this.read(s, felderImStrom, 2, 0L);
            long maxMem = this.read(s, felderImStrom, 3, 0L);
            this.extraInfo = new ExtraInfo(maxMem, currentTimeInMillies, props);
        }

        private Object readResolve() {
            return this.extraInfo;
        }

        private <T> T read(ObjectInputStream s, int felderImStrom, int akt, T def) throws IOException, ClassNotFoundException {
            return (T)(felderImStrom >= akt ? s.readObject() : def);
        }

        private long read(ObjectInputStream s, int felderImStrom, int akt, long def) throws IOException, ClassNotFoundException {
            return felderImStrom >= akt ? s.readLong() : def;
        }
    }
}

