/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import de.lema.annotations.ThreadSafe;
import de.lema.appender.Identifikation;
import de.lema.appender.LemaLoggingEvent;
import de.lema.appender.LemaLoggingEventFactory;
import de.lema.appender.net.ConnectionProperties;
import de.lema.appender.net.SocketThread;
import de.lema.appender.net.SocketThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

@ThreadSafe
public final class LemaAppender
extends AppenderSkeleton {
    private String application = "DefaultApplication";
    private final AtomicReference<SocketThread> socketThread = new AtomicReference();
    private boolean locationInfo = true;
    private String port = "50233";
    private String reconnectionDelay = "15000";
    private String remoteHost = "127.0.0.1";
    private String environmentId = "4";
    private String applicationVersion = "";
    private String hostname = "";
    private boolean appendExtraInfo = true;
    private int bufferSize = 1000;
    private int connectOnDemandDisconnectTime = 60000;
    private boolean connectOnDemand = false;
    private String connectionLostStrategy = "";
    private String connectionLostStrategyParameter = "";
    private boolean sendeBeacon = true;
    private final SocketThreadFactory socketThreadFactory;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectOnDemand(boolean connectOnDemand) {
        this.connectOnDemand = connectOnDemand;
    }

    public int getConnectOnDemandDisconnectTime() {
        return this.connectOnDemandDisconnectTime;
    }

    public void setConnectOnDemandDisconnectTime(int connectOnDemandDisconnectTime) {
        this.connectOnDemandDisconnectTime = connectOnDemandDisconnectTime;
    }

    public boolean isConnectOnDemand() {
        return this.connectOnDemand;
    }

    public boolean isAppendExtraInfo() {
        return this.appendExtraInfo;
    }

    public void setAppendExtraInfo(boolean appendExtraInfo) {
        this.appendExtraInfo = appendExtraInfo;
    }

    public String getConnectionLostStrategyParameter() {
        return this.connectionLostStrategyParameter;
    }

    public void setConnectionLostStrategyParameter(String connectionLostStrategyParameter) {
        this.connectionLostStrategyParameter = connectionLostStrategyParameter;
    }

    public String getConnectionLostStrategy() {
        return this.connectionLostStrategy;
    }

    public void setConnectionLostStrategy(String connectionLostStrategy) {
        this.connectionLostStrategy = connectionLostStrategy;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public boolean getSendeBeacon() {
        return this.sendeBeacon;
    }

    public void setSendeBeacon(boolean sendeBeacon) {
        this.sendeBeacon = sendeBeacon;
    }

    LemaAppender(SocketThreadFactory socketThreadFactory) {
        this.socketThreadFactory = socketThreadFactory;
    }

    public LemaAppender() {
        this(SocketThreadFactory.INSTANCE);
    }

    public String resolve(String variable, String def) {
        String resolve;
        if (variable != null && (resolve = variable.trim()).length() > 3 && resolve.startsWith("${") && resolve.endsWith("}")) {
            return System.getProperty(resolve.substring(2, resolve.length() - 1), def);
        }
        return variable;
    }

    public synchronized void activateOptions() {
        this.setApplication(this.resolve(this.getApplication(), "DefaultApplication"));
        this.setEnvironmentId(this.resolve(this.getEnvironmentId(), "4"));
        this.setRemoteHost(this.resolve(this.getRemoteHost(), "127.0.0.1"));
        this.setReconnectionDelay(this.resolve(this.getReconnectionDelay(), "15000"));
        this.setPort(this.resolve(this.getPort(), "50233"));
        this.setHostname(this.resolve(this.getHostname(), ""));
        try {
            this.stopSender();
            Identifikation ident = Identifikation.create((String)this.getApplication(), (int)this.getEnvironmentIdAsInt(), (!this.isConnectOnDemand() && this.getSendeBeacon() ? 1 : 0) != 0, (String)this.getApplicationVersion(), (String)this.getHostname(), (boolean)this.isAppendExtraInfo());
            ConnectionProperties connectionProperties = new ConnectionProperties(ident, this.getRemoteHost(), this.getPortAsInt());
            if (ident.istValid() && connectionProperties.istValid()) {
                SocketThread update = this.socketThreadFactory.createInstance(this.getName(), connectionProperties, this.getReconnectionDelayAsInt(), ident, this.connectOnDemand, this.connectOnDemandDisconnectTime, this.getBufferSize() > 0 ? this.getBufferSize() : 1000);
                this.socketThread.set(update);
            } else {
                LogLog.error((String)"Applikation nicht gesetzt oder Addresse nicht korrekt");
            }
        }
        catch (Exception e) {
            LogLog.error((String)"Fataler Fehler beim Initialisieren des Senders", (Throwable)e);
        }
    }

    private long getReconnectionDelayAsInt() {
        try {
            return Integer.valueOf(this.reconnectionDelay).intValue();
        }
        catch (NumberFormatException e) {
            LogLog.error((String)("ReconnectionDelay nicht gesetzt bzw. keine Zahl: '" + this.reconnectionDelay + "'. Setzte Default."));
            return Integer.valueOf("15000").intValue();
        }
    }

    private int getPortAsInt() {
        try {
            return Integer.parseInt(this.port);
        }
        catch (NumberFormatException e) {
            LogLog.error((String)("Port nicht gesetzt bzw. keine Zahl: '" + this.port + "'. Setzte Default."));
            return Integer.parseInt("50233");
        }
    }

    public void append(LoggingEvent event) {
        if (event != null && !this.closed) {
            try {
                LemaLoggingEvent e = LemaLoggingEventFactory.create(event, this.getLocationInfo());
                SocketThread instance = this.socketThread.get();
                if (instance != null) {
                    instance.enqueForSending(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.stopSender();
        }
    }

    private synchronized void stopSender() {
        SocketThread old = this.socketThread.getAndSet(null);
        if (old != null) {
            old.cancel();
        }
    }

    public String getApplication() {
        return this.application;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public String getPort() {
        return this.port;
    }

    public String getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public int getEnvironmentIdAsInt() {
        try {
            return Integer.valueOf(this.environmentId);
        }
        catch (NumberFormatException e) {
            LogLog.error((String)("EnvironmentId nicht gesetzt bzw. keine Zahl: '" + this.environmentId + "'. Setzte Default."));
            return Integer.valueOf("4");
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setReconnectionDelay(String delay) {
        this.reconnectionDelay = delay;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }
}

