/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import de.lema.appender.ExceptionHelper;
import de.lema.appender.LemaLoggingEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class LemaLoggingEventFactory {
    public static LemaLoggingEvent create(LoggingEvent event, boolean locationInfo) {
        Throwable throwable;
        String message = event.getRenderedMessage();
        Throwable throwable2 = throwable = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
        String exceptionKlasse = throwable != null ? (throwable instanceof ExceptionHelper ? ((ExceptionHelper)throwable).getClassName() : throwable.getClass().getName()) : null;
        String exceptionMessage = throwable != null ? throwable.getMessage() : null;
        long datum = event.timeStamp;
        int level = event.getLevel().toInt();
        LocationInfo locationInformation = null;
        if (locationInfo) {
            locationInformation = event.getLocationInformation();
        }
        String className = LemaLoggingEventFactory.getKlasse(event, locationInformation);
        String methodName = locationInformation != null ? locationInformation.getMethodName() : null;
        int lineNumber = 0;
        if (locationInformation != null && locationInformation.getLineNumber() != null && !locationInformation.getLineNumber().equals("?")) {
            try {
                lineNumber = Integer.parseInt(locationInformation.getLineNumber());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String threadName = event.getThreadName();
        HashMap<String, String> mdc = new HashMap<String, String>();
        Hashtable context = MDC.getContext();
        if (context != null && !context.isEmpty()) {
            mdc = new HashMap();
            for (Map.Entry entry : context.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                mdc.put(key, value.toString());
            }
        }
        return new LemaLoggingEvent(message, mdc, throwable, null, datum, level, lineNumber, className, methodName, threadName, exceptionKlasse, exceptionMessage);
    }

    private static String getKlasse(LoggingEvent event, LocationInfo locationInfo) {
        if (locationInfo == null || "?".equals(locationInfo.getClassName())) {
            return event.getLoggerName();
        }
        return locationInfo.getClassName();
    }
}

