/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import de.lema.annotations.ThreadSafe;
import de.lema.appender.Identifikation;
import de.lema.appender.LemaLoggingEvent;
import de.lema.appender.LemaLoggingEventFactory;
import de.lema.appender.net.ConnectionProperties;
import de.lema.appender.net.SocketThread;
import de.lema.appender.net.SocketThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="LemaAppender", category="Core", elementType="appender", printObject=true)
@ThreadSafe
public final class LemaAppender
extends AbstractAppender {
    private String application = "DefaultApplication";
    private final AtomicReference<SocketThread> socketThread = new AtomicReference();
    private String port = "50233";
    private String reconnectionDelay = "15000";
    private String host = "127.0.0.1";
    private String environment = "4";
    private String applicationVersion = "";
    private String hostname = "";
    private int bufferSize = 1000;
    private int connectOnDemandDisconnectTime = 60000;
    private boolean connectOnDemand = false;
    private String connectionLostStrategy = "";
    private String connectionLostStrategyParameter = "";
    private boolean sendeBeacon = true;
    private final SocketThreadFactory socketThreadFactory = SocketThreadFactory.INSTANCE;

    public boolean requiresLocation() {
        return true;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectOnDemand(boolean connectOnDemand) {
        this.connectOnDemand = connectOnDemand;
    }

    public int getConnectOnDemandDisconnectTime() {
        return this.connectOnDemandDisconnectTime;
    }

    public void setConnectOnDemandDisconnectTime(int connectOnDemandDisconnectTime) {
        this.connectOnDemandDisconnectTime = connectOnDemandDisconnectTime;
    }

    public boolean isConnectOnDemand() {
        return this.connectOnDemand;
    }

    public String getConnectionLostStrategyParameter() {
        return this.connectionLostStrategyParameter;
    }

    public void setConnectionLostStrategyParameter(String connectionLostStrategyParameter) {
        this.connectionLostStrategyParameter = connectionLostStrategyParameter;
    }

    public String getConnectionLostStrategy() {
        return this.connectionLostStrategy;
    }

    public void setConnectionLostStrategy(String connectionLostStrategy) {
        this.connectionLostStrategy = connectionLostStrategy;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public boolean getSendeBeacon() {
        return this.sendeBeacon;
    }

    public void setSendeBeacon(boolean sendeBeacon) {
        this.sendeBeacon = sendeBeacon;
    }

    protected LemaAppender(String name, Filter filter) {
        super(name, filter, null);
    }

    @PluginFactory
    public static LemaAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="lemaHost") String lemaHost, @PluginAttribute(value="lemaPort") String lemaPort, @PluginAttribute(value="myHostname") String myHostname, @PluginAttribute(value="application") String application, @PluginAttribute(value="environment") String environment, @PluginAttribute(value="applicationVersion") String applicationVersion, @PluginAttribute(value="connectOnDemand") Boolean connectOnDemand) {
        LemaAppender lemaAppender = new LemaAppender(name, filter);
        lemaAppender.setHost(lemaHost);
        lemaAppender.setApplication(application);
        lemaAppender.setEnvironment(environment);
        if (applicationVersion != null) {
            lemaAppender.setApplicationVersion(applicationVersion);
        }
        if (lemaPort != null) {
            lemaAppender.setPort(lemaPort);
        }
        if (connectOnDemand != null) {
            lemaAppender.setConnectOnDemand(connectOnDemand);
        }
        if (myHostname != null) {
            lemaAppender.setHostname(myHostname);
        }
        return lemaAppender;
    }

    public String resolve(String variable, String def) {
        String resolve;
        if (variable != null && (resolve = variable.trim()).length() > 3 && resolve.startsWith("${") && resolve.endsWith("}")) {
            return System.getProperty(resolve.substring(2, resolve.length() - 1), def);
        }
        return variable;
    }

    public synchronized void start() {
        this.setApplication(this.resolve(this.getApplication(), "DefaultApplication"));
        this.setEnvironment(this.resolve(this.getEnvironment(), "4"));
        this.setHost(this.resolve(this.getHost(), "127.0.0.1"));
        this.setReconnectionDelay(this.resolve(this.getReconnectionDelay(), "15000"));
        this.setPort(this.resolve(this.getPort(), "50233"));
        this.setHostname(this.resolve(this.getHostname(), ""));
        try {
            this.stopSender();
            Identifikation ident = Identifikation.create((String)this.getApplication(), (int)this.getEnvironmentIdAsInt(), (!this.isConnectOnDemand() && this.getSendeBeacon() ? 1 : 0) != 0, (String)this.getApplicationVersion(), (String)this.getHostname(), (boolean)true);
            ConnectionProperties connectionProperties = new ConnectionProperties(ident, this.getHost(), this.getPortAsInt());
            if (ident.istValid() && connectionProperties.istValid()) {
                SocketThread update = this.createSenderController(ident, connectionProperties);
                this.socketThread.set(update);
            } else {
                AbstractLifeCycle.LOGGER.error("Applikation nicht gesetzt oder Addresse nicht korrekt");
            }
        }
        catch (Exception e) {
            AbstractLifeCycle.LOGGER.error("Fataler Fehler beim Initialisieren des Senders", (Throwable)e);
        }
        super.start();
    }

    public SocketThread createSenderController(Identifikation ident, ConnectionProperties connectionProperties) {
        return this.socketThreadFactory.createInstance(this.getName(), connectionProperties, this.getReconnectionDelayAsInt(), ident, this.connectOnDemand, this.connectOnDemandDisconnectTime, this.getBufferSize() > 0 ? this.getBufferSize() : 1000);
    }

    private long getReconnectionDelayAsInt() {
        try {
            return Integer.parseInt(this.reconnectionDelay);
        }
        catch (NumberFormatException e) {
            AbstractLifeCycle.LOGGER.error("ReconnectionDelay nicht gesetzt bzw. keine Zahl: '" + this.reconnectionDelay + "'. Setzte Default.");
            return Integer.parseInt("15000");
        }
    }

    private int getPortAsInt() {
        try {
            return Integer.parseInt(this.port);
        }
        catch (NumberFormatException e) {
            AbstractLifeCycle.LOGGER.error("Port nicht gesetzt bzw. keine Zahl: '" + this.port + "'. Setzte Default.");
            return Integer.parseInt("50233");
        }
    }

    public synchronized boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.stopSender();
        this.setStopped();
        return true;
    }

    private synchronized void stopSender() {
        SocketThread old = this.socketThread.getAndSet(null);
        if (old != null) {
            old.cancel();
        }
    }

    public String getApplication() {
        return this.application;
    }

    public String getPort() {
        return this.port;
    }

    public String getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public String getHost() {
        return this.host;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public int getEnvironmentIdAsInt() {
        try {
            return Integer.parseInt(this.environment);
        }
        catch (NumberFormatException e) {
            AbstractLifeCycle.LOGGER.error("EnvironmentId nicht gesetzt bzw. keine Zahl: '" + this.environment + "'. Setzte Default.");
            return Integer.parseInt("4");
        }
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setReconnectionDelay(String delay) {
        this.reconnectionDelay = delay;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void append(LogEvent logEvent) {
        if (logEvent != null && !this.isStopped()) {
            try {
                LemaLoggingEvent e = LemaLoggingEventFactory.create(logEvent);
                SocketThread instance = this.socketThread.get();
                if (instance != null) {
                    instance.enqueForSending(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

