/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import de.lema.appender.ExceptionHelper;
import de.lema.appender.LemaLoggingEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public class LemaLoggingEventFactory {
    public static LemaLoggingEvent create(LogEvent event) {
        Throwable throwable;
        Message message = event.getMessage();
        Throwable throwable2 = throwable = event.getThrown() != null ? event.getThrown() : null;
        String exceptionKlasse = throwable != null ? (throwable instanceof ExceptionHelper ? ((ExceptionHelper)throwable).getClassName() : throwable.getClass().getName()) : null;
        String exceptionMessage = throwable != null ? throwable.getMessage() : null;
        long datum = event.getTimeMillis();
        int level = LemaLoggingEventFactory.getLevel(event);
        StackTraceElement locationInformation = event.getSource();
        String className = LemaLoggingEventFactory.getKlasse(event, locationInformation);
        String methodName = locationInformation != null ? locationInformation.getMethodName() : null;
        int lineNumber = 0;
        if (locationInformation != null && locationInformation.getLineNumber() > 0) {
            lineNumber = locationInformation.getLineNumber();
        }
        String threadName = event.getThreadName();
        HashMap<String, String> mdc = new HashMap<String, String>();
        ReadOnlyStringMap context = event.getContextData();
        if (context != null && !context.isEmpty()) {
            for (Map.Entry entry : context.toMap().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key == null || value == null) continue;
                mdc.put(key, value);
            }
        }
        return LemaLoggingEventFactory.create(message.getFormattedMessage(), throwable, exceptionKlasse, exceptionMessage, datum, level, className, methodName, lineNumber, threadName, mdc);
    }

    private static int getLevel(LogEvent event) {
        StandardLevel level = event.getLevel().getStandardLevel();
        switch (level) {
            case FATAL: {
                return 50000;
            }
            case ERROR: {
                return 40000;
            }
            case WARN: {
                return 30000;
            }
            case INFO: {
                return 20000;
            }
            case DEBUG: {
                return 10000;
            }
            case TRACE: {
                return 500;
            }
            case ALL: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    private static LemaLoggingEvent create(String message, Throwable throwable, String exceptionKlasse, String exceptionMessage, long datum, int level, String className, String methodName, int lineNumber, String threadName, HashMap<String, String> mdc) {
        return new LemaLoggingEvent(message, mdc, throwable, null, datum, level, lineNumber, className, methodName, threadName, exceptionKlasse, exceptionMessage);
    }

    private static String getKlasse(LogEvent event, StackTraceElement locationInfo) {
        if (locationInfo == null) {
            return event.getLoggerName();
        }
        return locationInfo.getClassName();
    }
}

