/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import de.lema.annotations.ThreadSafe;
import de.lema.appender.Identifikation;
import de.lema.appender.LemaLoggingEvent;
import de.lema.appender.LemaLoggingEventFactory;
import de.lema.appender.net.ConnectionProperties;
import de.lema.appender.net.SocketThread;
import de.lema.appender.net.SocketThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public final class LemaAppender
extends AppenderBase<LoggingEvent> {
    private String application = "DefaultApplication";
    private final AtomicReference<SocketThread> socketThread = new AtomicReference();
    private boolean locationInfo = true;
    private String port = "50233";
    private String reconnectionDelay = "15000";
    private String remoteHost = "127.0.0.1";
    private String environmentId = "4";
    private String applicationVersion = "";
    private String hostname = "";
    private boolean appendExtraInfo = true;
    private int bufferSize = 1000;
    private int connectOnDemandDisconnectTime = 60000;
    private boolean connectOnDemand = false;
    private String connectionLostStrategy = "";
    private String connectionLostStrategyParameter = "";
    private boolean sendeBeacon = true;
    private final SocketThreadFactory socketThreadFactory;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectOnDemand(boolean connectOnDemand) {
        this.connectOnDemand = connectOnDemand;
    }

    public int getConnectOnDemandDisconnectTime() {
        return this.connectOnDemandDisconnectTime;
    }

    public void setConnectOnDemandDisconnectTime(int connectOnDemandDisconnectTime) {
        this.connectOnDemandDisconnectTime = connectOnDemandDisconnectTime;
    }

    public boolean isConnectOnDemand() {
        return this.connectOnDemand;
    }

    public boolean isAppendExtraInfo() {
        return this.appendExtraInfo;
    }

    public void setAppendExtraInfo(boolean appendExtraInfo) {
        this.appendExtraInfo = appendExtraInfo;
    }

    public String getConnectionLostStrategyParameter() {
        return this.connectionLostStrategyParameter;
    }

    public void setConnectionLostStrategyParameter(String connectionLostStrategyParameter) {
        this.connectionLostStrategyParameter = connectionLostStrategyParameter;
    }

    public String getConnectionLostStrategy() {
        return this.connectionLostStrategy;
    }

    public void setConnectionLostStrategy(String connectionLostStrategy) {
        this.connectionLostStrategy = connectionLostStrategy;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public boolean getSendeBeacon() {
        return this.sendeBeacon;
    }

    public void setSendeBeacon(boolean sendeBeacon) {
        this.sendeBeacon = sendeBeacon;
    }

    LemaAppender(SocketThreadFactory socketThreadFactory) {
        this.socketThreadFactory = socketThreadFactory;
    }

    public LemaAppender() {
        this(SocketThreadFactory.INSTANCE);
    }

    public String resolve(String variable, String def) {
        String resolve;
        if (variable != null && (resolve = variable.trim()).length() > 3 && resolve.startsWith("${") && resolve.endsWith("}")) {
            return System.getProperty(resolve.substring(2, resolve.length() - 1), def);
        }
        return variable;
    }

    public synchronized void start() {
        this.setApplication(this.resolve(this.getApplication(), "DefaultApplication"));
        this.setEnvironmentId(this.resolve(this.getEnvironmentId(), "4"));
        this.setRemoteHost(this.resolve(this.getRemoteHost(), "127.0.0.1"));
        this.setReconnectionDelay(this.resolve(this.getReconnectionDelay(), "15000"));
        this.setPort(this.resolve(this.getPort(), "50233"));
        this.setHostname(this.resolve(this.getHostname(), ""));
        try {
            this.stopSender();
            Identifikation ident = Identifikation.create((String)this.getApplication(), (int)this.getEnvironmentIdAsInt(), (!this.isConnectOnDemand() && this.getSendeBeacon() ? 1 : 0) != 0, (String)this.getApplicationVersion(), (String)this.getHostname(), (boolean)this.isAppendExtraInfo());
            ConnectionProperties connectionProperties = new ConnectionProperties(ident, this.getRemoteHost(), this.getPortAsInt());
            if (!ident.istValid()) {
                this.addWarn("Application identification is not valid");
            }
            if (!connectionProperties.istValid()) {
                this.addWarn("Could not resolve Hostname or ip address '" + this.getRemoteHost() + "'");
            }
            if (ident.istValid() && connectionProperties.istValid()) {
                SocketThread update = this.createSenderController(ident, connectionProperties);
                this.socketThread.set(update);
            }
        }
        catch (Exception e) {
            this.addWarn("Unexpected exception during sender startup", e);
        }
        super.start();
    }

    public SocketThread createSenderController(Identifikation ident, ConnectionProperties connectionProperties) {
        return this.socketThreadFactory.createInstance(this.getName(), connectionProperties, this.getReconnectionDelayAsInt(), ident, this.connectOnDemand, this.connectOnDemandDisconnectTime, this.getBufferSize() > 0 ? this.getBufferSize() : 1000);
    }

    private long getReconnectionDelayAsInt() {
        try {
            return Integer.parseInt(this.reconnectionDelay);
        }
        catch (NumberFormatException e) {
            this.addWarn("Configured reconnectionDelay is not valid '" + this.reconnectionDelay + "', value is set to default (" + "15000" + " )");
            return Integer.parseInt("15000");
        }
    }

    private int getPortAsInt() {
        try {
            return Integer.parseInt(this.port);
        }
        catch (NumberFormatException e) {
            this.addWarn("Configured port is not valid '" + this.port + "', value is set to default (" + "50233" + " )");
            return Integer.parseInt("50233");
        }
    }

    public void append(LoggingEvent event) {
        if (event != null && this.isStarted()) {
            try {
                LemaLoggingEvent e = LemaLoggingEventFactory.create(event, this.getLocationInfo());
                SocketThread instance = this.socketThread.get();
                if (instance != null) {
                    instance.enqueForSending(e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            super.stop();
            this.stopSender();
        }
    }

    private synchronized void stopSender() {
        SocketThread old = this.socketThread.getAndSet(null);
        if (old != null) {
            old.cancel();
        }
    }

    public String getApplication() {
        return this.application;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public String getPort() {
        return this.port;
    }

    public String getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public int getEnvironmentIdAsInt() {
        try {
            return Integer.parseInt(this.environmentId);
        }
        catch (NumberFormatException e) {
            this.addWarn("Configured EnvironmentId is not valid '" + this.environmentId + "', value is set to default (" + "4" + " )");
            return Integer.parseInt("4");
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setReconnectionDelay(String delay) {
        this.reconnectionDelay = delay;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }
}

