/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender.net;

import de.lema.appender.net.ObjectSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public abstract class AbstractObjectWriter {
    protected static final int PREFIX_SIZE = 4;
    private FileChannel channel;
    private ByteBuffer headerBuffer;
    protected static final int ELEMENT_LENGTH = 13;
    private RandomAccessFile randomAccessFile;

    protected AbstractObjectWriter() {
    }

    public void close() throws IOException {
        if (this.isFileOpen()) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
            this.channel = null;
            this.headerBuffer = null;
        }
    }

    protected void createHeaderbuffer(int maxElementeImHeader) {
        if (this.headerBuffer == null) {
            this.headerBuffer = ByteBuffer.allocate(this.berechneErsteSchreibposition(maxElementeImHeader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readAndUpdateHeader(int maxElementeImHeader) throws IOException, ClassNotFoundException {
        FileLock lock = null;
        Object back = null;
        HeaderElement found = this.findBelegt();
        if (found != null) {
            try {
                lock = this.channel.lock(0L, maxElementeImHeader, false);
                byte[] in = this.readObject(found);
                back = ObjectSerializer.deserialize(in);
                HeaderElement deleted = found.setDeleted();
                this.writeHeaderElement(deleted, false);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAndUpdateHeader(HeaderElement headerElementAkt, byte[] serializeObject, int maxElementeImHeader) throws IOException {
        FileLock lock = null;
        try {
            lock = this.channel.lock(0L, maxElementeImHeader, false);
            this.writeObject(serializeObject, headerElementAkt.getStartPosImBody());
            this.writeHeaderElement(headerElementAkt, true);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initHeaderBufferWennNotwendig() throws IOException {
        int maxElementeImHeader = -1;
        FileLock lock = null;
        if (this.headerBuffer == null) {
            try {
                lock = this.channel.lock(0L, 4L, false);
                ByteBuffer laenge = ByteBuffer.allocate(4);
                this.channel.position(0L);
                while (laenge.hasRemaining()) {
                    this.channel.read(laenge);
                }
                maxElementeImHeader = laenge.getInt(0);
                if (maxElementeImHeader < 1) {
                    throw new IllegalStateException("Der Header in der Datei ist fehlerhaft");
                }
                this.createHeaderbuffer(maxElementeImHeader);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        return maxElementeImHeader;
    }

    private byte[] readObject(HeaderElement found) throws IOException {
        byte[] in = new byte[found.getLengthImBody()];
        ByteBuffer buf = ByteBuffer.wrap(in);
        this.channel.position(found.getStartPosImBody());
        while (buf.hasRemaining()) {
            this.channel.read(buf);
        }
        return in;
    }

    private HeaderElement erstelleElementWennPosition0(HeaderElement heOld, int ersteSchreibposition) {
        if (heOld == null) {
            heOld = new HeaderElement(ersteSchreibposition, 0, -1);
        }
        return heOld;
    }

    private HeaderElement findBelegt() throws IOException {
        int anzahlElemente = this.readHeader();
        HeaderElement found = null;
        for (int i = 0; i < anzahlElemente; ++i) {
            HeaderElement he = new HeaderElement(this.headerBuffer, i);
            if (!he.istBelegt()) continue;
            found = he;
            break;
        }
        return found;
    }

    protected boolean isFileOpen() {
        return this.channel != null;
    }

    protected void openFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new IllegalArgumentException("Die Datei " + file + " existiert nicht.");
        }
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this.channel = this.randomAccessFile.getChannel();
    }

    private int readHeader() throws IOException {
        this.headerBuffer.clear();
        this.channel.position(0L);
        while (this.headerBuffer.hasRemaining()) {
            this.channel.read(this.headerBuffer);
        }
        this.headerBuffer.position(0);
        return this.headerBuffer.getInt();
    }

    protected int berechneErsteSchreibposition(int maxElementeImHeader) {
        return 4 + maxElementeImHeader * 13;
    }

    protected void writeEmptyHeader(int maxElementeImHeader) throws IOException {
        this.createHeaderbuffer(this.berechneErsteSchreibposition(maxElementeImHeader));
        this.headerBuffer.putInt(0, maxElementeImHeader);
        this.channel.position(0L);
        while (this.headerBuffer.hasRemaining()) {
            this.channel.write(this.headerBuffer);
        }
    }

    protected void writeHeaderElement(HeaderElement heNeu, boolean mitLock) throws IOException {
        this.headerBuffer.clear();
        heNeu.writeToBuffer(this.headerBuffer);
        this.headerBuffer.flip();
        this.channel.position(heNeu.getStartPosInHeader());
        while (this.headerBuffer.hasRemaining()) {
            this.channel.write(this.headerBuffer);
        }
    }

    protected void writeObject(byte[] serializeObject, long startPos) throws IOException {
        ByteBuffer out = ByteBuffer.wrap(serializeObject);
        this.channel.position(startPos);
        while (out.hasRemaining()) {
            this.channel.write(out);
        }
    }

    protected static class HeaderElement {
        private static final int ELEMENT_LENGTH = 13;
        private static final byte STATUS_BELEGT = 1;
        private static final byte STATUS_DELETE = 2;
        private static final byte STATUS_FREI = 0;
        private final int lengthImBody;
        private final int elementNummerImHeader;
        private final long startPosImBody;
        private final byte status;

        private HeaderElement(byte status, long startPos, int length, int position) {
            this.status = status;
            this.startPosImBody = startPos;
            this.lengthImBody = length;
            this.elementNummerImHeader = position;
        }

        public int getStartPosInHeader() {
            return 4 + this.getElementNummerImHeader() * 13;
        }

        public HeaderElement(ByteBuffer buffer, int position) {
            this(buffer.get(), buffer.getLong(), buffer.getInt(), position);
        }

        public HeaderElement(long startPos, int length, int position) {
            this(1, startPos, length, position);
        }

        public int getLengthImBody() {
            return this.lengthImBody;
        }

        public int getElementNummerImHeader() {
            return this.elementNummerImHeader;
        }

        public long getStartPosImBody() {
            return this.startPosImBody;
        }

        public boolean istBelegt() {
            return this.status == 1;
        }

        public boolean istFrei() {
            return this.status == 0;
        }

        public boolean istGeloescht() {
            return this.status == 2;
        }

        public HeaderElement setDeleted() {
            return new HeaderElement(2, this.startPosImBody, this.lengthImBody, this.elementNummerImHeader);
        }

        public String toString() {
            return "pos=" + this.elementNummerImHeader + ", status=" + this.status + ",  start=" + this.startPosImBody + ", Laenge=" + this.lengthImBody;
        }

        public void writeToBuffer(ByteBuffer headerBuffer) {
            headerBuffer.put(this.status);
            headerBuffer.putLong(this.startPosImBody);
            headerBuffer.putInt(this.lengthImBody);
        }

        public long getLengthImHeader() {
            return 13L;
        }
    }
}

