/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender.net;

import de.lema.annotations.Immutable;
import de.lema.appender.Identifikation;
import java.net.InetAddress;

@Immutable
public class ConnectionProperties {
    private final InetAddress address;
    private final String host;
    private final Identifikation ident;
    private final int port;

    private static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ConnectionProperties(Identifikation ident, String host, int port) {
        this.ident = ident;
        this.host = host;
        this.port = port;
        this.address = ConnectionProperties.getAddressByName(host);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getHost() {
        return this.host;
    }

    public Identifikation getIdent() {
        return this.ident;
    }

    public int getPort() {
        return this.port;
    }

    public boolean istValid() {
        return this.address != null;
    }
}

