/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender.net;

import de.lema.annotations.NotThreadSafe;
import de.lema.appender.net.AbstractObjectWriter;
import de.lema.appender.net.ObjectSerializer;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

@NotThreadSafe
public class ObjectWriter<T>
extends AbstractObjectWriter {
    private final File dir;
    private final int maxElementeImHeader;
    private AbstractObjectWriter.HeaderElement headerElementAkt;
    private final Random random;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private final String applikation;

    public ObjectWriter(int headerLenght, File dir, String applikation) {
        if (dir.isFile() || !dir.exists()) {
            throw new IllegalArgumentException("Verzeichnis existiert nicht oder ist eine Datei.");
        }
        if (headerLenght < 1) {
            throw new IllegalArgumentException("Die Headergroesse muss groesser 0 sein, war " + headerLenght);
        }
        this.dir = dir;
        this.random = new Random(System.currentTimeMillis());
        this.applikation = applikation;
        this.maxElementeImHeader = headerLenght;
    }

    private int createRandomNumber() {
        return this.random.nextInt(1000000);
    }

    private File generateFile() throws IOException {
        Date jetzt = new Date(System.currentTimeMillis());
        int random = this.createRandomNumber();
        File file = new File(this.dir.getAbsolutePath() + File.separator + "log-" + this.applikation + "-" + SDF.format(jetzt) + "-" + random + ".data");
        boolean ok = file.createNewFile();
        if (!ok) {
            throw new IllegalStateException("Die Datei konnte nicht angelegt werden bzw. existiert bereits.");
        }
        return file;
    }

    private void createNewFile() throws IOException {
        this.openFile(this.generateFile());
        this.writeEmptyHeader(this.maxElementeImHeader);
    }

    public long write(T o) throws IOException {
        if (o == null) {
            throw new IllegalArgumentException("Object war null");
        }
        if (!this.isFileOpen()) {
            this.createNewFile();
            this.headerElementAkt = new AbstractObjectWriter.HeaderElement(this.berechneErsteSchreibposition(this.maxElementeImHeader), 0, -1);
        }
        byte[] serializeObject = ObjectSerializer.serializeObject(o);
        int length = serializeObject.length;
        this.headerElementAkt = new AbstractObjectWriter.HeaderElement(this.headerElementAkt.getStartPosImBody() + (long)this.headerElementAkt.getLengthImBody(), serializeObject.length, this.headerElementAkt.getElementNummerImHeader() + 1);
        this.writeAndUpdateHeader(this.headerElementAkt, serializeObject, this.maxElementeImHeader);
        if (this.headerElementAkt == null || this.headerElementAkt.getElementNummerImHeader() >= this.maxElementeImHeader - 1) {
            this.close();
        }
        return this.headerElementAkt.getStartPosImBody() + (long)length;
    }
}

