/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender.net;

import de.lema.annotations.GuardedBy;
import de.lema.annotations.ThreadSafe;
import de.lema.appender.net.ConnectionClosedException;
import de.lema.appender.net.ConnectionProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

@ThreadSafe
public class SocketFassade {
    private static final int TIMEOUT = 10000;
    private static final AtomicInteger errorCounter = new AtomicInteger(0);
    private volatile boolean istClosed;
    @GuardedBy(lock="ois")
    private final ObjectInputStream ois;
    @GuardedBy(lock="oos")
    private final ObjectOutputStream oos;
    @GuardedBy(lock="this")
    private final Socket socket;

    public static SocketFassade create(ConnectionProperties data) {
        try {
            SocketFassade socketFassade = new SocketFassade(data);
            errorCounter.set(0);
            return socketFassade;
        }
        catch (ConnectException e) {
            return null;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        catch (ConnectionClosedException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private SocketFassade(ConnectionProperties data) throws IOException {
        this.socket = new Socket(data.getAddress(), data.getPort());
        this.socket.setSoTimeout(10000);
        this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        this.ois = new ObjectInputStream(this.socket.getInputStream());
        boolean ok = this.write(data.getIdent());
        if (!ok) {
            throw new ConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SocketFassade socketFassade = this;
        synchronized (socketFassade) {
            if (!this.istClosed) {
                this.istClosed = true;
                try {
                    this.ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.oos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean istClosed() {
        return this.istClosed;
    }

    public Object read() throws Exception {
        ObjectInputStream objectInputStream = this.ois;
        synchronized (objectInputStream) {
            if (!this.istClosed) {
                try {
                    Object readObject = this.ois.readObject();
                    return readObject;
                }
                catch (Exception e) {
                    this.close();
                    throw e;
                }
            }
            throw new Exception("Verbindung ist schon geschlossen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Object tosend) {
        ObjectOutputStream objectOutputStream = this.oos;
        synchronized (objectOutputStream) {
            if (!this.istClosed) {
                try {
                    this.oos.writeObject(tosend);
                    this.oos.flush();
                    this.oos.reset();
                    return true;
                }
                catch (Exception e) {
                    this.close();
                    return false;
                }
            }
            return false;
        }
    }
}

