/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender.net;

import de.lema.annotations.ThreadSafe;
import de.lema.appender.LemaLoggingEvent;
import de.lema.appender.net.Beacon;
import de.lema.appender.net.Factory;
import de.lema.appender.net.SocketFassade;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public class SocketThread
extends Thread {
    private static final long HOUR_IN_MILLIS = 3600000L;
    private final long reconnectionDelay;
    private final Factory<SocketFassade> socketProvider;
    private final CountDownLatch startGate;
    private final int connectOnDemandDisconnectTime;
    private final boolean connectOnDemand;
    private final ArrayBlockingQueue<LemaLoggingEvent> queue;
    private final long beaconFix = 120L;
    private final int beaconVar = 60;
    private final Random random;
    private int unsuccessfullConnectionCount;
    private boolean firstConnectSucessfullyFinisched;
    private SocketFassade socketFassade;
    private volatile boolean running;
    private final Object lock = new Object();

    CountDownLatch getStartGate() {
        return this.startGate;
    }

    SocketThread(String name, long reconnectionDelay, Factory<SocketFassade> socketProvider, boolean connectOnDemand, int connectOnDemandDisconnectTime, int bufferSize) {
        super("LemaThread" + (name != null && name.length() > 0 ? "-" + name : ""));
        this.connectOnDemand = connectOnDemand;
        this.connectOnDemandDisconnectTime = connectOnDemandDisconnectTime;
        this.startGate = new CountDownLatch(1);
        this.socketProvider = socketProvider;
        this.setDaemon(true);
        this.setPriority(1);
        this.running = true;
        this.reconnectionDelay = reconnectionDelay;
        this.queue = new ArrayBlockingQueue(bufferSize);
        this.random = new Random(System.currentTimeMillis());
    }

    private boolean connect() {
        try {
            SocketFassade create = this.socketProvider.get();
            if (create != null) {
                this.setSocket(create);
                this.unsuccessfullConnectionCount = 0;
                return true;
            }
            ++this.unsuccessfullConnectionCount;
            return false;
        }
        catch (Exception e) {
            ++this.unsuccessfullConnectionCount;
            return false;
        }
    }

    private void setSocket(SocketFassade neu) {
        SocketFassade old = this.getSocketFassade();
        if (old != null) {
            old.close();
        }
        this.socketFassade = neu;
        if (neu != null) {
            if (this.firstConnectSucessfullyFinisched) {
                this.afterReconnect();
            } else {
                this.startupFinished();
            }
        }
    }

    private void afterReconnect() {
    }

    private void startupFinished() {
        this.firstConnectSucessfullyFinisched = true;
        this.startGate.countDown();
    }

    SocketFassade getSocketFassade() {
        if (this.socketFassade == null) {
            return null;
        }
        if (this.socketFassade.istClosed()) {
            this.socketFassade = null;
            return null;
        }
        return this.socketFassade;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        try {
            if (this.connectOnDemand) {
                this.runOnDemand();
            } else {
                this.runBeacon();
            }
        }
        catch (InterruptedException e) {
            this.running = false;
        }
    }

    private void runBeacon() throws InterruptedException {
        this.connect();
        while (this.running) {
            if (this.getSocketFassade() != null) {
                Serializable take = (Serializable)this.queue.poll(this.beaconFix + (long)this.random.nextInt(this.beaconVar), TimeUnit.SECONDS);
                if (take == null) {
                    boolean ok = this.write((Serializable)Beacon.BEACON);
                    if (!ok) continue;
                    this.read();
                    continue;
                }
                this.write(take);
                continue;
            }
            SocketThread.sleep(this.calcSleepTime());
            this.connect();
        }
    }

    private void runOnDemand() throws InterruptedException {
        this.startupFinished();
        while (this.running) {
            Serializable take;
            Serializable serializable = take = this.getSocketFassade() == null ? (Serializable)this.queue.take() : (Serializable)this.queue.poll(this.connectOnDemandDisconnectTime, TimeUnit.MILLISECONDS);
            if (take != null) {
                boolean ok;
                if (this.getSocketFassade() == null) {
                    this.connect();
                }
                if (ok = this.write(take)) continue;
                SocketThread.sleep(this.calcSleepTime());
                continue;
            }
            this.setSocket(null);
        }
    }

    private long calcSleepTime() {
        long time = this.reconnectionDelay;
        for (int i = 0; i < this.unsuccessfullConnectionCount; ++i) {
            if (time > 3600000L) {
                time = time * 3L / 2L;
                continue;
            }
            time *= 2L;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.running = false;
        this.interrupt();
        Object object = this.lock;
        synchronized (object) {
            this.setSocket(null);
        }
    }

    Object read() {
        SocketFassade instance = this.getSocketFassade();
        if (instance != null) {
            try {
                return instance.read();
            }
            catch (Exception e) {
                this.deregister(instance);
            }
        }
        return null;
    }

    boolean write(Serializable toSend) {
        SocketFassade instance = this.getSocketFassade();
        boolean ok = false;
        if (instance != null && !(ok = instance.write(toSend))) {
            this.deregister(instance);
        }
        if (!ok && toSend instanceof LemaLoggingEvent) {
            this.onFailure((LemaLoggingEvent)toSend);
        }
        return ok;
    }

    private void onFailure(LemaLoggingEvent toSend) {
        if (toSend.registerFailure() < 10) {
            this.enqueForSending(toSend);
        } else {
            this.onError(toSend);
        }
    }

    private void deregister(SocketFassade instance) {
        instance.close();
        this.socketFassade = null;
    }

    public void enqueForSending(LemaLoggingEvent event) {
        if (this.running) {
            while (!this.queue.offer(event)) {
                LemaLoggingEvent poll = this.queue.poll();
                if (poll == null) continue;
                this.onOverflow(poll);
            }
        }
    }

    public void onOverflow(LemaLoggingEvent poll) {
    }

    public void onError(LemaLoggingEvent poll) {
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    static SocketThread createInstance(String name, Factory<SocketFassade> provider, long reconnectionDelay, boolean connectOnDemand, int connectOnDemandDisconnectTime, int bufferSize) {
        SocketThread instance = new SocketThread(name, reconnectionDelay, provider, connectOnDemand, connectOnDemandDisconnectTime, bufferSize);
        instance.start();
        return instance;
    }
}

