/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender.net;

import de.lema.appender.Identifikation;
import de.lema.appender.net.ConnectionProperties;
import de.lema.appender.net.Factory;
import de.lema.appender.net.SocketFassade;
import de.lema.appender.net.SocketThread;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SocketThreadFactory {
    public static final SocketThreadFactory INSTANCE = new SocketThreadFactory();
    private final HashMap<Instanz, SocketThread> MAP = new HashMap();

    private SocketThreadFactory() {
    }

    public synchronized SocketThread createInstance(String name, ConnectionProperties props, long reconnectionDelay, Identifikation ident, boolean connectOnDemand, int connectOnDemandDisconnectTime, int bufferSize) {
        Instanz key = new Instanz(ident.getAnwendung(), ident.getUmgebung(), name);
        this.close(key);
        SocketThread value = SocketThread.createInstance(key.toString(), new SocketFassadeFactory(props), reconnectionDelay, connectOnDemand, connectOnDemandDisconnectTime, bufferSize);
        this.MAP.put(key, value);
        return value;
    }

    public synchronized void close(String anwendung, int umgebung, String name) {
        this.close(new Instanz(anwendung, umgebung, name));
    }

    public synchronized void closeAll() {
        Set<Map.Entry<Instanz, SocketThread>> entrySet = this.MAP.entrySet();
        for (Map.Entry<Instanz, SocketThread> entry : entrySet) {
            SocketThread value = entry.getValue();
            if (value == null) continue;
            value.cancel();
        }
        this.MAP.clear();
    }

    private synchronized void close(Instanz key) {
        SocketThread old = this.MAP.remove(key);
        if (old != null) {
            old.cancel();
        }
    }

    private static class SocketFassadeFactory
    implements Factory<SocketFassade> {
        private final ConnectionProperties connectionProperties;

        public SocketFassadeFactory(ConnectionProperties connectionProperties) {
            this.connectionProperties = connectionProperties;
        }

        @Override
        public SocketFassade get() {
            if (this.connectionProperties.istValid()) {
                return SocketFassade.create(this.connectionProperties);
            }
            return null;
        }
    }

    private static class Instanz {
        private final String name;
        private final String anwendung;
        private final int umgebung;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.anwendung == null ? 0 : this.anwendung.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.umgebung;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Instanz other = (Instanz)obj;
            if (this.anwendung == null ? other.anwendung != null : !this.anwendung.equals(other.anwendung)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.umgebung == other.umgebung;
        }

        public String toString() {
            return "" + this.anwendung + "-" + this.umgebung + (this.name != null && this.name.length() > 0 ? "-" + this.name : "");
        }

        public Instanz(String anwendung, int umgebung, String name) {
            this.anwendung = anwendung;
            this.umgebung = umgebung;
            this.name = name;
        }
    }
}

