/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq;

import com.gluonhq.attach.AttachArtifactResolver;
import com.gluonhq.substrate.Constants;
import com.gluonhq.substrate.ProjectConfiguration;
import com.gluonhq.substrate.SubstrateDispatcher;
import com.gluonhq.substrate.model.IosSigningConfiguration;
import com.gluonhq.substrate.model.Triplet;
import com.gluonhq.utils.MavenArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public abstract class NativeBaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Component
    BuildPluginManager pluginManager;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    File basedir;
    @Parameter(property="client.graalvmHome")
    String graalvmHome;
    @Parameter(property="client.javaStaticSdkVersion")
    String javaStaticSdkVersion;
    @Parameter(property="client.javafxStaticSdkVersion")
    String javafxStaticSdkVersion;
    @Parameter(property="client.target", defaultValue="host")
    String target;
    @Parameter(property="client.bundlesList")
    List<String> bundlesList;
    @Parameter(property="client.resourcesList")
    List<String> resourcesList;
    @Parameter(property="client.reflectionList")
    List<String> reflectionList;
    @Parameter(property="client.jniList")
    List<String> jniList;
    @Parameter(property="client.nativeImageArgs")
    List<String> nativeImageArgs;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.directory}/client")
    File outputDir;
    @Parameter(property="client.mainClass", required=true)
    String mainClass;
    @Parameter(property="client.executable", defaultValue="java")
    String executable;
    @Parameter(property="client.verbose", defaultValue="false")
    String verbose;
    @Parameter(property="client.attachList")
    List<String> attachList;
    @Parameter(property="client.enableSWRendering", defaultValue="false")
    String enableSWRendering;
    @Parameter(property="client.IOSSigningIdentity")
    String IOSSigningIdentity;
    @Parameter(property="client.IOSProvisioningProfile")
    String IOSProvisioningProfile;
    @Parameter(property="client.IOSSkipSigning")
    String IOSSkipSigning;
    private ProcessDestroyer processDestroyer;

    public SubstrateDispatcher createSubstrateDispatcher() throws IOException, MojoExecutionException {
        if (!this.getGraalvmHome().isPresent()) {
            throw new MojoExecutionException("GraalVM installation directory not found. Either set GRAALVM_HOME as an environment variable or set graalvmHome in client-plugin configuration");
        }
        ProjectConfiguration substrateConfiguration = this.createSubstrateConfiguration();
        return new SubstrateDispatcher(this.outputDir.toPath(), substrateConfiguration);
    }

    private ProjectConfiguration createSubstrateConfiguration() {
        Triplet targetTriplet;
        ProjectConfiguration clientConfig = new ProjectConfiguration(this.mainClass, this.getProjectClasspath());
        clientConfig.setGraalPath(Path.of(this.getGraalvmHome().get(), new String[0]));
        clientConfig.setJavaStaticSdkVersion(this.javaStaticSdkVersion);
        clientConfig.setJavafxStaticSdkVersion(this.javafxStaticSdkVersion);
        switch (this.target) {
            case "host": {
                targetTriplet = Triplet.fromCurrentOS();
                break;
            }
            case "ios": {
                targetTriplet = new Triplet(Constants.Profile.IOS);
                IosSigningConfiguration signingConfiguration = new IosSigningConfiguration();
                signingConfiguration.setProvidedSigningIdentity(this.IOSSigningIdentity);
                signingConfiguration.setProvidedProvisioningProfile(this.IOSProvisioningProfile);
                signingConfiguration.setSkipSigning(this.IOSSkipSigning != null && "true".equals(this.IOSSkipSigning));
                clientConfig.setIosSigningConfiguration(signingConfiguration);
                break;
            }
            case "ios-sim": {
                targetTriplet = new Triplet(Constants.Profile.IOS_SIM);
                break;
            }
            case "android": {
                targetTriplet = new Triplet(Constants.Profile.ANDROID);
                break;
            }
            case "linux-aarch64": {
                targetTriplet = new Triplet(Constants.Profile.LINUX_AARCH64);
                break;
            }
            default: {
                throw new RuntimeException("No valid target found for " + this.target);
            }
        }
        clientConfig.setTarget(targetTriplet);
        clientConfig.setBundlesList(this.bundlesList);
        clientConfig.setResourcesList(this.resourcesList);
        clientConfig.setJniList(this.jniList);
        clientConfig.setCompilerArgs(this.nativeImageArgs);
        clientConfig.setReflectionList(this.reflectionList);
        clientConfig.setAppId(this.project.getGroupId() + "." + this.project.getArtifactId());
        clientConfig.setAppName(this.project.getName());
        clientConfig.setVerbose("true".equals(this.verbose));
        clientConfig.setUsePrismSW("true".equals(this.enableSWRendering));
        return clientConfig;
    }

    ProcessDestroyer getProcessDestroyer() {
        if (this.processDestroyer == null) {
            this.processDestroyer = new ShutdownHookProcessDestroyer();
        }
        return this.processDestroyer;
    }

    private String getProjectClasspath() {
        List<File> classPath = this.getClasspathElements(this.project);
        this.getLog().debug((CharSequence)("classPath = " + classPath));
        return classPath.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    private List<File> getClasspathElements(MavenProject project) {
        List<org.apache.maven.artifact.Artifact> attachDependencies = this.getAttachDependencies();
        List<File> list = Stream.concat(project.getArtifacts().stream(), attachDependencies.stream()).sorted((a1, a2) -> {
            int compare = a1.compareTo(a2);
            if (compare == 0) {
                return a1.hasClassifier() ? 1 : (a2.hasClassifier() ? -1 : 0);
            }
            return compare;
        }).map(org.apache.maven.artifact.Artifact::getFile).collect(Collectors.toList());
        list.add(0, new File(project.getBuild().getOutputDirectory()));
        this.getRuntimeDependencies().stream().filter(d -> !list.contains(d)).forEach(list::add);
        this.getProvidedDependencies().stream().filter(list::contains).forEach(list::remove);
        return list;
    }

    List<org.apache.maven.artifact.Artifact> getAttachDependencies() {
        Map<String, org.apache.maven.artifact.Artifact> attachMap = AttachArtifactResolver.findArtifactsForTarget(this.project.getDependencies(), this.project.getRepositories(), this.target);
        if (this.attachList != null) {
            return Stream.concat(this.attachList.stream(), Stream.of("util")).distinct().map(attachMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<org.apache.maven.artifact.Artifact>();
    }

    private List<File> getRuntimeDependencies() {
        return this.getDependencies("runtime");
    }

    private List<File> getProvidedDependencies() {
        return this.getDependencies("provided");
    }

    private List<File> getDependencies(String scope) {
        if (scope == null || scope.isEmpty()) {
            return new ArrayList<File>();
        }
        MavenArtifactResolver resolver = new MavenArtifactResolver(this.project.getRepositories());
        return this.project.getDependencies().stream().filter(d -> scope.equals(d.getScope())).map(d -> new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion())).flatMap(a -> {
            Set<org.apache.maven.artifact.Artifact> resolve = resolver.resolve((Artifact)a);
            if (resolve == null) {
                return Stream.empty();
            }
            return resolve.stream();
        }).distinct().map(org.apache.maven.artifact.Artifact::getFile).collect(Collectors.toList());
    }

    private Optional<String> getGraalvmHome() {
        if (this.graalvmHome != null) {
            return Optional.of(this.graalvmHome);
        }
        if (System.getenv("GRAALVM_HOME") != null) {
            return Optional.of(System.getenv("GRAALVM_HOME"));
        }
        return Optional.empty();
    }
}

