/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable;

import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.partition.bag.PartitionMutableBag;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.SynchronizedBag;
import com.gs.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import com.gs.collections.impl.factory.Bags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableBag<T>
extends UnmodifiableMutableCollection<T>
implements MutableBag<T> {
    private static final long serialVersionUID = 1L;

    protected UnmodifiableBag(MutableBag<? extends T> mutableBag) {
        super(mutableBag);
    }

    public static <E, B extends MutableBag<E>> UnmodifiableBag<E> of(B bag) {
        if (bag == null) {
            throw new IllegalArgumentException("cannot create an UnmodifiableBag for null");
        }
        return new UnmodifiableBag(bag);
    }

    protected MutableBag<T> getMutableBag() {
        return (MutableBag)this.getMutableCollection();
    }

    @Override
    public MutableBag<T> asUnmodifiable() {
        return this;
    }

    @Override
    public MutableBag<T> asSynchronized() {
        return SynchronizedBag.of(this);
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.ofAll((Iterable)((Object)this));
    }

    public boolean equals(Object obj) {
        return this.getMutableBag().equals(obj);
    }

    public int hashCode() {
        return this.getMutableBag().hashCode();
    }

    public String toStringOfItemToCount() {
        return this.getMutableBag().toStringOfItemToCount();
    }

    @Override
    public MutableBag<T> newEmpty() {
        return this.getMutableBag().newEmpty();
    }

    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        return this.getMutableBag().selectByOccurrences(predicate);
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        return this.getMutableBag().select(predicate);
    }

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableBag().selectWith(predicate, parameter);
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return this.getMutableBag().reject(predicate);
    }

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableBag().rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        return this.getMutableBag().partition(predicate);
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        return this.getMutableBag().selectInstancesOf(clazz);
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return this.getMutableBag().collect(function);
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.getMutableBag().collectBoolean(booleanFunction);
    }

    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return this.getMutableBag().collectByte(byteFunction);
    }

    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return this.getMutableBag().collectChar(charFunction);
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.getMutableBag().collectDouble(doubleFunction);
    }

    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return this.getMutableBag().collectFloat(floatFunction);
    }

    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return this.getMutableBag().collectInt(intFunction);
    }

    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return this.getMutableBag().collectLong(longFunction);
    }

    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return this.getMutableBag().collectShort(shortFunction);
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.getMutableBag().flatCollect(function);
    }

    @Override
    public <P, A> MutableBag<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.getMutableBag().collectWith(function, parameter);
    }

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.getMutableBag().collectIf(predicate, function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.getMutableBag().groupBy(function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.getMutableBag().groupByEach(function);
    }

    public void addOccurrences(T item, int occurrences) {
        throw new UnsupportedOperationException();
    }

    public boolean removeOccurrences(Object item, int occurrences) {
        throw new UnsupportedOperationException();
    }

    public int sizeDistinct() {
        return this.getMutableBag().sizeDistinct();
    }

    public int occurrencesOf(Object item) {
        return this.getMutableBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.getMutableBag().forEachWithOccurrences(objectIntProcedure);
    }

    public MutableMap<T, Integer> toMapOfItemToCount() {
        return this.getMutableBag().toMapOfItemToCount();
    }

    @Override
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return this.getMutableBag().zip(that);
    }

    @Override
    public MutableBag<Pair<T, Integer>> zipWithIndex() {
        return this.getMutableBag().zipWithIndex();
    }

    @Override
    public MutableBag<T> with(T element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBag<T> without(T element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBag<T> withAll(Iterable<? extends T> elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }
}

