/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory.primitive;

import com.gs.collections.api.block.predicate.primitive.DoublePredicate;

public final class DoublePredicates {
    private DoublePredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static DoublePredicate equal(double expected) {
        return new EqualsDoublePredicate(expected);
    }

    public static DoublePredicate equal(double expected, double delta) {
        return new EqualsWithDeltaDoublePredicate(expected, delta);
    }

    public static DoublePredicate lessThan(double expected) {
        return new LessThanDoublePredicate(expected);
    }

    public static DoublePredicate greaterThan(double expected) {
        return new GreaterThanDoublePredicate(expected);
    }

    public static DoublePredicate and(DoublePredicate one, DoublePredicate two) {
        return new AndDoublePredicate(one, two);
    }

    public static DoublePredicate or(DoublePredicate one, DoublePredicate two) {
        return new OrDoublePredicate(one, two);
    }

    public static DoublePredicate not(DoublePredicate negate) {
        return new NotDoublePredicate(negate);
    }

    private static final class NotDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final DoublePredicate negate;

        private NotDoublePredicate(DoublePredicate negate) {
            this.negate = negate;
        }

        public boolean accept(double actual) {
            return !this.negate.accept(actual);
        }
    }

    private static final class OrDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final DoublePredicate one;
        private final DoublePredicate two;

        private OrDoublePredicate(DoublePredicate one, DoublePredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(double actual) {
            return this.one.accept(actual) || this.two.accept(actual);
        }
    }

    private static final class AndDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final DoublePredicate one;
        private final DoublePredicate two;

        private AndDoublePredicate(DoublePredicate one, DoublePredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(double actual) {
            return this.one.accept(actual) && this.two.accept(actual);
        }
    }

    private static final class GreaterThanDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final double expected;

        private GreaterThanDoublePredicate(double expected) {
            this.expected = expected;
        }

        public boolean accept(double actual) {
            return actual > this.expected;
        }
    }

    private static final class LessThanDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final double expected;

        private LessThanDoublePredicate(double expected) {
            this.expected = expected;
        }

        public boolean accept(double actual) {
            return actual < this.expected;
        }
    }

    private static final class EqualsWithDeltaDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final double expected;
        private final double delta;

        private EqualsWithDeltaDoublePredicate(double expected, double delta) {
            this.expected = expected;
            this.delta = delta;
        }

        public boolean accept(double actual) {
            return Math.abs(this.expected - actual) <= this.delta;
        }
    }

    private static final class EqualsDoublePredicate
    implements DoublePredicate {
        private static final long serialVersionUID = 1L;
        private final double expected;

        private EqualsDoublePredicate(double expected) {
            this.expected = expected;
        }

        public boolean accept(double actual) {
            return Double.compare(actual, this.expected) == 0;
        }
    }
}

