/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory.primitive;

import com.gs.collections.api.block.predicate.primitive.IntPredicate;

public final class IntPredicates {
    private static final IntIsEvenPredicate IS_EVEN = new IntIsEvenPredicate();
    private static final IntIsOddPredicate IS_ODD = new IntIsOddPredicate();

    private IntPredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static IntPredicate equal(int expected) {
        return new EqualsIntPredicate(expected);
    }

    public static IntPredicate lessThan(int expected) {
        return new LessThanIntPredicate(expected);
    }

    public static IntPredicate greaterThan(int expected) {
        return new GreaterThanIntPredicate(expected);
    }

    public static IntPredicate isEven() {
        return IS_EVEN;
    }

    public static IntPredicate isOdd() {
        return IS_ODD;
    }

    public static IntPredicate and(IntPredicate one, IntPredicate two) {
        return new AndIntPredicate(one, two);
    }

    public static IntPredicate or(IntPredicate one, IntPredicate two) {
        return new OrIntPredicate(one, two);
    }

    public static IntPredicate not(IntPredicate negate) {
        return new NotIntPredicate(negate);
    }

    private static final class IntIsOddPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;

        private IntIsOddPredicate() {
        }

        public boolean accept(int integral) {
            return integral % 2 != 0;
        }
    }

    private static final class IntIsEvenPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;

        private IntIsEvenPredicate() {
        }

        public boolean accept(int integral) {
            return integral % 2 == 0;
        }
    }

    private static final class NotIntPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;
        private final IntPredicate negate;

        private NotIntPredicate(IntPredicate negate) {
            this.negate = negate;
        }

        public boolean accept(int actual) {
            return !this.negate.accept(actual);
        }
    }

    private static final class OrIntPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;
        private final IntPredicate one;
        private final IntPredicate two;

        private OrIntPredicate(IntPredicate one, IntPredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(int actual) {
            return this.one.accept(actual) || this.two.accept(actual);
        }
    }

    private static final class AndIntPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;
        private final IntPredicate one;
        private final IntPredicate two;

        private AndIntPredicate(IntPredicate one, IntPredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(int actual) {
            return this.one.accept(actual) && this.two.accept(actual);
        }
    }

    private static final class GreaterThanIntPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;
        private final int expected;

        private GreaterThanIntPredicate(int expected) {
            this.expected = expected;
        }

        public boolean accept(int actual) {
            return actual > this.expected;
        }
    }

    private static final class LessThanIntPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;
        private final int expected;

        private LessThanIntPredicate(int expected) {
            this.expected = expected;
        }

        public boolean accept(int actual) {
            return actual < this.expected;
        }
    }

    private static final class EqualsIntPredicate
    implements IntPredicate {
        private static final long serialVersionUID = 1L;
        private final int expected;

        private EqualsIntPredicate(int expected) {
            this.expected = expected;
        }

        public boolean accept(int actual) {
            return actual == this.expected;
        }
    }
}

