/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.block.factory.primitive.BooleanPredicates;
import com.gs.collections.impl.lazy.primitive.CollectBooleanToObjectIterable;
import com.gs.collections.impl.lazy.primitive.SelectBooleanIterable;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectBooleanIterable<T>
implements LazyBooleanIterable {
    private final LazyIterable<T> iterable;
    private final BooleanFunction<? super T> function;
    private final BooleanFunctionToProcedure booleanFunctionToProcedure = new BooleanFunctionToProcedure();

    public CollectBooleanIterable(LazyIterable<T> adapted, BooleanFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
    }

    public BooleanIterator booleanIterator() {
        return new BooleanIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectBooleanIterable.this.iterable.iterator();
            }

            public boolean next() {
                return CollectBooleanIterable.this.function.booleanValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void forEach(BooleanProcedure procedure) {
        this.iterable.forEachWith((Procedure2)this.booleanFunctionToProcedure, (Object)procedure);
    }

    public int size() {
        return this.iterable.size();
    }

    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    public int count(final BooleanPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    public boolean anySatisfy(final BooleanPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    public boolean allSatisfy(final BooleanPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    public boolean noneSatisfy(final BooleanPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectBooleanIterable.this.function.booleanValueOf(each));
            }
        });
    }

    public LazyBooleanIterable select(BooleanPredicate predicate) {
        return new SelectBooleanIterable((BooleanIterable)this, predicate);
    }

    public LazyBooleanIterable reject(BooleanPredicate predicate) {
        return new SelectBooleanIterable((BooleanIterable)this, BooleanPredicates.not(predicate));
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        BooleanIterator iterator = this.booleanIterator();
        while (iterator.hasNext()) {
            boolean next = iterator.next();
            if (!predicate.accept(next)) continue;
            return next;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(BooleanToObjectFunction<? extends V> function) {
        return new CollectBooleanToObjectIterable<V>((BooleanIterable)this, function);
    }

    public boolean[] toArray() {
        final boolean[] array = new boolean[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectBooleanIterable.this.function.booleanValueOf(each);
            }
        });
        return array;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            BooleanIterator iterator = this.booleanIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return this;
    }

    public boolean contains(boolean value) {
        return this.anySatisfy(BooleanPredicates.equal(value));
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BooleanFunctionToProcedure
    implements Procedure2<T, BooleanProcedure> {
        private static final long serialVersionUID = -4133872659735979655L;

        private BooleanFunctionToProcedure() {
        }

        public void value(T each, BooleanProcedure parm) {
            parm.value(CollectBooleanIterable.this.function.booleanValueOf(each));
        }
    }
}

