/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectIntIterable
implements LazyIntIterable {
    private final IntIterable delegate;
    private final IntPredicate predicate;

    public SelectIntIterable(IntIterable delegate, IntPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public IntIterator intIterator() {
        return new SelectIntIterator(this.delegate, this.predicate);
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.forEach((IntProcedure)new IfIntProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.intIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.intIterator().hasNext();
    }

    public int count(IntPredicate predicate) {
        CountIntProcedure countIntProcedure = new CountIntProcedure(predicate);
        this.forEach(countIntProcedure);
        return countIntProcedure.getCount();
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(IntPredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.noneSatisfy(IntPredicates.not(predicate));
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public LazyIntIterable select(IntPredicate predicate) {
        return new SelectIntIterable((IntIterable)this, predicate);
    }

    public LazyIntIterable reject(IntPredicate predicate) {
        return new SelectIntIterable((IntIterable)this, IntPredicates.not(predicate));
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            int item = intIterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>((IntIterable)this, function);
    }

    public long sum() {
        long sum = 0L;
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            sum += (long)intIterator.next();
        }
        return sum;
    }

    public int max() {
        IntIterator intIterator = this.intIterator();
        int max = intIterator.next();
        while (intIterator.hasNext()) {
            max = Math.max(max, intIterator.next());
        }
        return max;
    }

    public int min() {
        IntIterator intIterator = this.intIterator();
        int min = intIterator.next();
        while (intIterator.hasNext()) {
            min = Math.min(min, intIterator.next());
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public int maxIfEmpty(int defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public int[] toArray() {
        final int[] array = new int[this.size()];
        this.forEach(new IntProcedure(){
            private int index = 0;

            public void value(int each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            IntIterator iterator = this.intIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(int value) {
        return this.anySatisfy(IntPredicates.equal(value));
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return this;
    }

    private static final class SelectIntIterator
    implements IntIterator {
        private final IntIterator iterator;
        private final IntPredicate predicate;
        private int next;
        private boolean verifiedHasNext = false;

        private SelectIntIterator(IntIterable iterable, IntPredicate predicate) {
            this(iterable.intIterator(), predicate);
        }

        private SelectIntIterator(IntIterator iterator, IntPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                int temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public int next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfIntProcedure
    implements IntProcedure {
        private static final long serialVersionUID = 1L;
        private final IntProcedure procedure;

        private IfIntProcedure(IntProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(int each) {
            if (SelectIntIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountIntProcedure
    implements IntProcedure {
        private static final long serialVersionUID = 1L;
        private final IntPredicate predicate;
        private int counter = 0;

        private CountIntProcedure(IntPredicate predicate) {
            this.predicate = predicate;
        }

        public void value(int each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

