/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.fixed;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.list.fixed.AbstractMemoryEfficientMutableList;
import com.gs.collections.impl.list.fixed.DoubletonList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
final class SingletonList<T>
extends AbstractMemoryEfficientMutableList<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private T element1;

    public SingletonList() {
    }

    SingletonList(T obj1) {
        this.element1 = obj1;
    }

    @Override
    public DoubletonList<T> with(T value) {
        return new DoubletonList<T>(this.element1, value);
    }

    @Override
    public SingletonList<T> clone() {
        return new SingletonList<T>(this.element1);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object obj) {
        return Comparators.nullSafeEquals(obj, this.element1);
    }

    public T get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    public T set(int index, T element) {
        if (index == 0) {
            T previousElement = this.element1;
            this.element1 = element;
            return previousElement;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public SingletonList<T> sortThis(Comparator<? super T> comparator) {
        return this;
    }

    @Override
    public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
        return this;
    }

    @Override
    public T getFirst() {
        return this.element1;
    }

    @Override
    public T getLast() {
        return this.element1;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.element1, 0);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        procedure.value(this.element1, parameter);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element1 = in.readObject();
    }
}

