/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.partition.list.PartitionImmutableList;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.CountProcedure;
import com.gs.collections.impl.block.procedure.FastListCollectIfProcedure;
import com.gs.collections.impl.block.procedure.FastListCollectProcedure;
import com.gs.collections.impl.block.procedure.FastListRejectProcedure;
import com.gs.collections.impl.block.procedure.FastListSelectProcedure;
import com.gs.collections.impl.block.procedure.MultimapPutProcedure;
import com.gs.collections.impl.list.immutable.AbstractImmutableList;
import com.gs.collections.impl.parallel.BatchIterable;
import com.gs.collections.impl.partition.list.PartitionImmutableListImpl;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableArrayList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess,
BatchIterable<T> {
    private static final long serialVersionUID = 1L;
    private final T[] items;

    private ImmutableArrayList(T[] newElements) {
        this.items = newElements;
    }

    public static <E> ImmutableArrayList<E> newList(Iterable<? extends E> iterable) {
        return new ImmutableArrayList<Object>(Iterate.toArray(iterable));
    }

    public static <E> ImmutableArrayList<E> newListWith(E ... elements) {
        return new ImmutableArrayList<Object>((Object[])elements.clone());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int localSize = this.size();
        for (int i = 0; i < localSize; ++i) {
            T item = this.items[i];
            hashCode = 31 * hashCode + (item == null ? 0 : item.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof List)) {
            return false;
        }
        List list = (List)otherList;
        if (otherList instanceof ImmutableArrayList) {
            return this.immutableArrayListEquals((ImmutableArrayList)otherList);
        }
        if (list instanceof RandomAccess) {
            return this.randomAccessListEquals(list);
        }
        return this.regularListEquals(list);
    }

    public boolean immutableArrayListEquals(ImmutableArrayList<?> otherList) {
        return Arrays.equals(this.items, otherList.items);
    }

    @Override
    protected boolean randomAccessListEquals(List<?> otherList) {
        if (this.size() != otherList.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            T one = this.items[i];
            Object two = otherList.get(i);
            if (Comparators.nullSafeEquals(one, two)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean regularListEquals(List<?> otherList) {
        Iterator<?> iterator = otherList.iterator();
        for (int i = 0; i < this.size(); ++i) {
            T one = this.items[i];
            if (!iterator.hasNext()) {
                return false;
            }
            Object two = iterator.next();
            if (Comparators.nullSafeEquals(one, two)) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Override
    public boolean notEmpty() {
        return ArrayIterate.notEmpty(this.items);
    }

    @Override
    public T getFirst() {
        return ArrayIterate.getFirst(this.items);
    }

    @Override
    public T getLast() {
        return ArrayIterate.getLast(this.items);
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        ArrayIterate.forEach(this.items, procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        ArrayIterate.forEachWithIndex(this.items, objectIntProcedure);
    }

    @Override
    public void batchForEach(Procedure<? super T> procedure, int sectionIndex, int sectionCount) {
        int end;
        int sectionSize = this.size() / sectionCount;
        int start = sectionSize * sectionIndex;
        int n = end = sectionIndex == sectionCount - 1 ? this.size() : start + sectionSize;
        if (procedure instanceof FastListSelectProcedure) {
            this.batchFastListSelect(start, end, (FastListSelectProcedure)procedure);
        } else if (procedure instanceof FastListCollectProcedure) {
            this.batchFastListCollect(start, end, (FastListCollectProcedure)procedure);
        } else if (procedure instanceof FastListCollectIfProcedure) {
            this.batchFastListCollectIf(start, end, (FastListCollectIfProcedure)procedure);
        } else if (procedure instanceof CountProcedure) {
            this.batchCount(start, end, (CountProcedure)procedure);
        } else if (procedure instanceof FastListRejectProcedure) {
            this.batchReject(start, end, (FastListRejectProcedure)procedure);
        } else if (procedure instanceof MultimapPutProcedure) {
            this.batchGroupBy(start, end, (MultimapPutProcedure)procedure);
        } else {
            for (int i = start; i < end; ++i) {
                procedure.value(this.items[i]);
            }
        }
    }

    private void batchGroupBy(int start, int end, MultimapPutProcedure<?, T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(this.items[i]);
        }
    }

    private void batchReject(int start, int end, FastListRejectProcedure<T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(this.items[i]);
        }
    }

    private void batchCount(int start, int end, CountProcedure<T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(this.items[i]);
        }
    }

    private void batchFastListCollectIf(int start, int end, FastListCollectIfProcedure<T, ?> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(this.items[i]);
        }
    }

    private void batchFastListCollect(int start, int end, FastListCollectProcedure<T, ?> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(this.items[i]);
        }
    }

    private void batchFastListSelect(int start, int end, FastListSelectProcedure<T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(this.items[i]);
        }
    }

    @Override
    public int getBatchCount(int batchSize) {
        return Math.max(1, this.size() / batchSize);
    }

    @Override
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        T[] localItems = this.items;
        for (int i = fromIndex; i <= toIndex; ++i) {
            objectIntProcedure.value(localItems[i], i);
        }
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return ArrayIterate.detect(this.items, predicate);
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        T result = this.detect(predicate);
        if (result == null) {
            return (T)function.value();
        }
        return result;
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        return ArrayIterate.count(this.items, predicate);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.anySatisfy(this.items, predicate);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.allSatisfy(this.items, predicate);
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return ArrayIterate.injectInto(injectedValue, this.items, function);
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public boolean isEmpty() {
        return ArrayIterate.isEmpty(this.items);
    }

    @Override
    public boolean contains(Object o) {
        return this.anySatisfy(Predicates.equal(o));
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.items).iterator();
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.items.clone();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(this.items, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int localSize = this.items.length;
        T[] localItems = this.items;
        for (int i = 0; i < localSize; ++i) {
            T item = localItems[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(item == this ? "(this ImmutableArrayList)" : String.valueOf(item));
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return Iterate.allSatisfy(collection, Predicates.in(this.items));
    }

    @Override
    public T get(int index) {
        return this.items[index];
    }

    @Override
    public int indexOf(Object item) {
        return ArrayIterate.indexOf(this.items, item);
    }

    @Override
    public int lastIndexOf(Object item) {
        return Arrays.asList(this.items).lastIndexOf(item);
    }

    public ImmutableList<T> newWith(T newItem) {
        int oldSize = this.size();
        Object[] array = new Object[oldSize + 1];
        this.toArray((E[])array);
        array[oldSize] = newItem;
        return new ImmutableArrayList<Object>(array);
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return ArrayIterate.minBy(this.items, function);
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return ArrayIterate.maxBy(this.items, function);
    }

    @Override
    public ImmutableList<T> takeWhile(Predicate<? super T> predicate) {
        int endIndex = this.detectNotIndex(predicate);
        Object[] result = new Object[endIndex];
        System.arraycopy(this.items, 0, result, 0, endIndex);
        return new ImmutableArrayList<Object>(result);
    }

    @Override
    public ImmutableList<T> dropWhile(Predicate<? super T> predicate) {
        int startIndex = this.detectNotIndex(predicate);
        int resultSize = this.size() - startIndex;
        Object[] result = new Object[resultSize];
        System.arraycopy(this.items, startIndex, result, 0, resultSize);
        return new ImmutableArrayList<Object>(result);
    }

    @Override
    public PartitionImmutableList<T> partitionWhile(Predicate<? super T> predicate) {
        int partitionIndex = this.detectNotIndex(predicate);
        int rejectedSize = this.size() - partitionIndex;
        Object[] selectedArray = new Object[partitionIndex];
        Object[] rejectedArray = new Object[rejectedSize];
        System.arraycopy(this.items, 0, selectedArray, 0, partitionIndex);
        System.arraycopy(this.items, partitionIndex, rejectedArray, 0, rejectedSize);
        ImmutableArrayList<Object> selected = new ImmutableArrayList<Object>(selectedArray);
        ImmutableArrayList<Object> rejected = new ImmutableArrayList<Object>(rejectedArray);
        return new PartitionImmutableListImpl<Object>(selected, rejected);
    }

    private int detectNotIndex(Predicate<? super T> predicate) {
        for (int index = 0; index < this.size(); ++index) {
            if (predicate.accept(this.items[index])) continue;
            return index;
        }
        return this.size();
    }
}

