/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.CharDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.CharDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableCharDoubleMap;
import com.gs.collections.api.map.primitive.MutableCharDoubleMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedCharDoubleProcedure;
import com.gs.collections.impl.map.mutable.primitive.CharDoubleHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharDoubleHashMap
implements ImmutableCharDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharDoubleMap delegate;

    ImmutableCharDoubleHashMap(CharDoubleMap delegate) {
        this.delegate = new CharDoubleHashMap(delegate);
    }

    public double get(char key) {
        return this.delegate.get(key);
    }

    public double getIfAbsent(char key, double ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(char key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(CharDoubleProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableCharDoubleMap select(CharDoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharDoubleMap reject(CharDoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableCharDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return this.delegate.doubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum() {
        return this.delegate.sum();
    }

    public double max() {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min() {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    public double[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableCharDoubleMap newWithKeyValue(char key, double value) {
        CharDoubleHashMap map = new CharDoubleHashMap(this.size() + 1);
        map.putAll((CharDoubleMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharDoubleMap newWithoutKey(char key) {
        CharDoubleHashMap map = new CharDoubleHashMap(this.size());
        map.putAll((CharDoubleMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableCharDoubleMap newWithoutAllKeys(CharIterable keys) {
        CharDoubleHashMap map = new CharDoubleHashMap(this.size());
        map.putAll((CharDoubleMap)this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableCharSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableCharDoubleMapSerializationProxy((CharDoubleMap)this);
    }

    protected static class ImmutableCharDoubleMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharDoubleMap map;

        public ImmutableCharDoubleMapSerializationProxy() {
        }

        protected ImmutableCharDoubleMapSerializationProxy(CharDoubleMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((CharDoubleProcedure)new CheckedCharDoubleProcedure(){

                    public void safeValue(char key, double value) throws IOException {
                        out.writeChar(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharDoubleHashMap deserializedMap = new CharDoubleHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readChar(), in.readDouble());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

