/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.CharIntMap;
import com.gs.collections.api.map.primitive.ImmutableCharIntMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharIntMaps;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharIntSingletonMap
implements ImmutableCharIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final char key1;
    private final int value1;

    ImmutableCharIntSingletonMap(char key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public int get(char key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(char key, int ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public int getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharIntProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView() {
        return CharIntHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableCharIntMap select(CharIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharIntHashMap().toImmutable();
    }

    public ImmutableCharIntMap reject(CharIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharIntHashMap().toImmutable() : CharIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableCharIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return CharIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator();
    }

    public void forEach(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public int min() {
        return this.value1;
    }

    public int max() {
        return this.value1;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntArrayList.newListWith(this.value1).toImmutable() : new IntArrayList().toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? new IntArrayList().toImmutable() : IntArrayList.newListWith(this.value1).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public int[] toArray() {
        return new int[]{this.value1};
    }

    public boolean contains(int value) {
        return this.value1 == value;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableCharIntMap newWithKeyValue(char key, int value) {
        return CharIntMaps.immutable.withAll((CharIntMap)CharIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharIntMap newWithoutKey(char key) {
        return this.key1 == key ? CharIntMaps.immutable.with() : this;
    }

    public ImmutableCharIntMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharIntMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableCharSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharIntMap)) {
            return false;
        }
        CharIntMap map = (CharIntMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

