/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.DoubleIntMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleIntMap;
import com.gs.collections.api.map.primitive.MutableDoubleIntMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleIntProcedure;
import com.gs.collections.impl.map.mutable.primitive.DoubleIntHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleIntHashMap
implements ImmutableDoubleIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleIntMap delegate;

    ImmutableDoubleIntHashMap(DoubleIntMap delegate) {
        this.delegate = new DoubleIntHashMap(delegate);
    }

    public int get(double key) {
        return this.delegate.get(key);
    }

    public int getIfAbsent(double key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableDoubleIntMap select(DoubleIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleIntMap reject(DoubleIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableDoubleIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return this.delegate.intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleIntMap newWithKeyValue(double key, int value) {
        DoubleIntHashMap map = new DoubleIntHashMap(this.size() + 1);
        map.putAll((DoubleIntMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleIntMap newWithoutKey(double key) {
        DoubleIntHashMap map = new DoubleIntHashMap(this.size());
        map.putAll((DoubleIntMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleIntMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleIntHashMap map = new DoubleIntHashMap(this.size());
        map.putAll((DoubleIntMap)this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleIntMapSerializationProxy((DoubleIntMap)this);
    }

    protected static class ImmutableDoubleIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleIntMap map;

        public ImmutableDoubleIntMapSerializationProxy() {
        }

        protected ImmutableDoubleIntMapSerializationProxy(DoubleIntMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((DoubleIntProcedure)new CheckedDoubleIntProcedure(){

                    public void safeValue(double key, int value) throws IOException {
                        out.writeDouble(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleIntHashMap deserializedMap = new DoubleIntHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readDouble(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

