/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.DoubleToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.DoubleFloatMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleFloatMap;
import com.gs.collections.api.map.primitive.MutableDoubleFloatMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.factory.primitive.DoubleFloatMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleFloatMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableDoubleFloatMap
implements MutableDoubleFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleFloatMap map;

    UnmodifiableDoubleFloatMap(MutableDoubleFloatMap map) {
        this.map = map;
    }

    private boolean isAbsent(float result, double key) {
        return result == 0.0f && !this.containsKey(key);
    }

    private float getIfAbsentThrow(double key) {
        float result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(double key, float value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(DoubleFloatMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(double key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(double key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public float removeKeyIfAbsent(double key, float value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public float getIfAbsentPut(double key, float value) {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPut(double key, FloatFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPutWithKey(double key, DoubleToFloatFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> float getIfAbsentPutWith(double key, FloatFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public float updateValue(double key, float initialValueIfAbsent, FloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public float get(double key) {
        return this.map.get(key);
    }

    public float getIfAbsent(double key, float ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(double key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleFloatProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.map.keysView();
    }

    public MutableDoubleFloatMap select(DoubleFloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableDoubleFloatMap reject(DoubleFloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public FloatIterator floatIterator() {
        return this.map.floatIterator();
    }

    public void forEach(FloatProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public double sum() {
        return this.map.sum();
    }

    public float max() {
        return this.map.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.map.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public float[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.map.toSortedList();
    }

    public float[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(float value) {
        return this.map.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.map.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.map.toList();
    }

    public MutableFloatSet toSet() {
        return this.map.toSet();
    }

    public MutableFloatBag toBag() {
        return this.map.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableDoubleFloatMap withKeyValue(double key, float value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleFloatMap withoutKey(double key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleFloatMap withoutAllKeys(DoubleIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleFloatMap asUnmodifiable() {
        return this;
    }

    public MutableDoubleFloatMap asSynchronized() {
        return new SynchronizedDoubleFloatMap(this);
    }

    public ImmutableDoubleFloatMap toImmutable() {
        return DoubleFloatMaps.immutable.withAll((DoubleFloatMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableFloatCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }
}

