/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.list;

import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.list.ImmutableListMultimap;
import com.gs.collections.api.multimap.list.MutableListMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.AbstractMutableMultimap;
import com.gs.collections.impl.multimap.list.ImmutableListMultimapImpl;
import java.io.Externalizable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastListMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableList<V>>
implements MutableListMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 1;
    private int initialListCapacity;

    public FastListMultimap() {
        this.initialListCapacity = 1;
    }

    public FastListMultimap(int distinctKeys, int valuesPerKey) {
        super(Math.max(distinctKeys * 2, 16));
        if (distinctKeys < 0 || valuesPerKey < 0) {
            throw new IllegalArgumentException("Both arguments must be positive.");
        }
        this.initialListCapacity = valuesPerKey;
    }

    public FastListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keysView().size(), multimap instanceof FastListMultimap ? ((FastListMultimap)multimap).initialListCapacity : 1);
        this.putAll(multimap);
    }

    public FastListMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    public static <K, V> FastListMultimap<K, V> newMultimap() {
        return new FastListMultimap<K, V>();
    }

    public static <K, V> FastListMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new FastListMultimap<K, V>(multimap);
    }

    public static <K, V> FastListMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new FastListMultimap<K, V>(pairs);
    }

    @Override
    protected MutableMap<K, MutableList<V>> createMap() {
        return UnifiedMap.newMap();
    }

    @Override
    protected MutableMap<K, MutableList<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected MutableList<V> createCollection() {
        return FastList.newList(this.initialListCapacity);
    }

    public void trimToSize() {
        for (Collection collection : this.map.values()) {
            FastList fastList = (FastList)collection;
            fastList.trimToSize();
        }
    }

    public FastListMultimap<K, V> newEmpty() {
        return new FastListMultimap<K, V>();
    }

    public MutableListMultimap<K, V> toMutable() {
        return new FastListMultimap<K, V>(this);
    }

    public ImmutableListMultimap<K, V> toImmutable() {
        final UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableList<V>>(){

            public void value(K key, MutableList<V> list) {
                map.put(key, (Object)list.toImmutable());
            }
        });
        return new ImmutableListMultimapImpl(map);
    }
}

