/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.BooleanList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.BooleanStack;
import com.gs.collections.api.stack.primitive.ImmutableBooleanStack;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.BooleanStacks;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.stack.mutable.primitive.BooleanArrayStack;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableBooleanSingletonStack
implements ImmutableBooleanStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean element1;

    ImmutableBooleanSingletonStack(boolean element) {
        this.element1 = element;
    }

    public BooleanIterator booleanIterator() {
        return BooleanArrayStack.newStackWith(this.element1).booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public boolean peek() {
        return this.element1;
    }

    public BooleanList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new BooleanArrayList(0);
        }
        if (count == 1) {
            return BooleanArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    public boolean peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    public ImmutableBooleanStack select(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? BooleanStacks.immutable.with(this.element1) : BooleanStacks.immutable.with();
    }

    public ImmutableBooleanStack reject(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? BooleanStacks.immutable.with() : BooleanStacks.immutable.with(this.element1);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    public boolean[] toArray() {
        return new boolean[]{this.element1};
    }

    public boolean contains(boolean value) {
        return this.element1 == value;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.element1);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.element1);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.element1);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public ImmutableBooleanStack toImmutable() {
        return this;
    }

    public ImmutableBooleanStack push(boolean element) {
        return BooleanStacks.immutable.with(new boolean[]{this.element1, element});
    }

    public ImmutableBooleanStack pop() {
        return BooleanStacks.immutable.with();
    }

    public ImmutableBooleanStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return BooleanStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof BooleanStack)) {
            return false;
        }
        BooleanStack stack = (BooleanStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    public int hashCode() {
        return 31 + (this.element1 ? 1231 : 1237);
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

